#include "mbed.h"
#include "XNucleo53L1A1.h"
#include "vl53L1x_I2c.h"
#include <stdio.h>

/* This VL53L1X Expansion board test application performs a range measurement in polling mode
   on the onboard embedded top sensor. */

#define VL53L1_I2C_SDA   D14 
#define VL53L1_I2C_SCL   D15 


/**
 * Expander 0 i2c address[7..0] format
 */
#define I2cExpAddr0 134 // (0x43*2)
/**
 * Expander 1 i2c address[7..0] format
 */
#define I2cExpAddr1 132 // (0x42*2)

/**
 * GPIO monitor pin state register
 * 16 bit register LSB at lowest offset (little endian)
 */
#define GPMR    0x10
/**
 * STMPE1600 GPIO set pin state register
 * 16 bit register LSB at lowest offset (little endian)
 */
#define GPSR    0x12
/**
 * STMPE1600 GPIO set pin direction register
 * 16 bit register LSB at lowest offset
 */
#define GPDR    0x14

static XNucleo53L1A1 *board=NULL;
Serial pc(SERIAL_TX, SERIAL_RX); 
 
/*=================================== Main ==================================
=============================================================================*/
int main()
{   
    int status;

    printf("Hello world!\r\n");

    vl53L1X_DevI2C *dev_I2C = new vl53L1X_DevI2C(VL53L1_I2C_SDA, VL53L1_I2C_SCL);

    printf("I2C device created!\r\n");
    
    /* creates the 53L0A1 expansion board singleton obj */
    board = XNucleo53L1A1::instance(dev_I2C, A2, D8, D2);
    printf("board created!\r\n");

    /* init the 53L0A1 expansion board with default values */
    status = board->init_board();
    if (status) {
        printf("Failed to init board!\r\n");
    //    return 0;
    }
    printf("board initiated! - %d\r\n", status);
    
    status = board->sensor_centre->VL53L1X_StartRanging();
    printf("start ranging! - %d\r\n", status);
    uint8_t ready = 0;
    uint16_t distance_centre = 0;
    
    while (1)
    {   
        do {
            board->sensor_centre->VL53L1X_CheckForDataReady(&ready);
        } while (!ready);

        board->sensor_centre->VL53L1X_GetRangeStatus(&ready);
        board->sensor_centre->VL53L1X_GetDistance(&distance_centre);
        //board->sensor_centre->VL53L1X_ClearInterrupt();
        printf("%d\t", distance_centre);
    }   
}
