#include "mbed.h"
#include "lib_TagType4.h"
#include "lib_NDEF_URI.h"

#define BLINK_LED_CYCLES 50 // M24SR command attempts before LED toggle

//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------
Serial pc(SERIAL_TX, SERIAL_RX);

// LED1
DigitalOut myled(LED1);

// Config LEDs on NUCLEO-NFC01A1
DigitalOut nfcled1(D5);
DigitalOut nfcled2(D4);
DigitalOut nfcled3(D2);

int main() {
    sURI_Info URIout;
    sURI_Info URIin;
    int BlinkLEDCounter = 0;
  
    memset(&URIin, 0x00, sizeof(URIin));
  
    // All LEDs on NFC shield off
    nfcled1 = 0;
    nfcled2 = 0;
    nfcled3 = 0;
  
    pc.printf("NFC Example\n");

    // Prepare URI NDEF message content
    pc.printf("Prepare URI NDEF message content\n");
    strcpy(URIout.protocol,URI_ID_0x01_STRING);
    strcpy(URIout.URI_Message,"st.com");
    strcpy(URIout.Information,"\0");
    pc.printf("Done\n\n");
    
    pc.printf("URIout contents:\n");
    pc.printf("URIout.protocol=%s\n", URIout.protocol);
    pc.printf("URIout Type: %d\n", getUriType(URIout.protocol));
    pc.printf("URIout.URI_Message=%s\n\n", URIout.URI_Message);
  
    pc.printf("Initializing Tag Type 4 Access ... ");
    // LED1 (green) on NCF shield indicates progress
    // blinking = initialization in progress
    // solid = init successfull
    BlinkLEDCounter = 0;
    while(TT4_Init()!=SUCCESS)
    {
        if(BlinkLEDCounter < BLINK_LED_CYCLES)
        {
            BlinkLEDCounter++;
        }
        else
        {
            BlinkLEDCounter=0;
            nfcled1 = !nfcled1;
        }
    }
    // success
    nfcled1 = 1;
    pc.printf("SUCCESS\n\n");

    // Write URI
    // LED2 (blue) on NCF shield indicates progress
    // blinking = write URI in progress
    // solid = write URI successfull
    pc.printf("Writing URI ... ");
    BlinkLEDCounter = 0;
    while (TT4_WriteURI(&URIout) != SUCCESS)
    {
        if(BlinkLEDCounter < BLINK_LED_CYCLES)
        {
            BlinkLEDCounter++;
        }
        else
        {
            BlinkLEDCounter=0;
            nfcled2 = !nfcled2;
        }
    }
    // success
    nfcled2 = 1;
    pc.printf("SUCCESS\n\n");
  
    // Read URI
    // LED3 (orange) on NCF shield indicates progress
    // blinking = read URI in progress
    // solid = read URI successfull
    pc.printf("Reading back URI ... ");
    BlinkLEDCounter = 0;
    while(TT4_ReadURI(&URIin) != SUCCESS)
    {
        if(BlinkLEDCounter < BLINK_LED_CYCLES)
        {
            BlinkLEDCounter++;
        }
        else
        {
            BlinkLEDCounter=0;
            nfcled3 = !nfcled3;
        } 
    }
    // success
    nfcled3 = 1;
    pc.printf("SUCCESS\n\n");
    
    // Display contents read back
    pc.printf("URIin contents:\n");
    pc.printf("URIin.protocol=%s\n", URIin.protocol);
    pc.printf("URIin Type: %d\n", getUriType(URIin.protocol));
    pc.printf("URIin.URI_Message=%s\n\n", URIin.URI_Message);
  
    // loop forever
    pc.printf("Done\n\n");
    while(1)
    {
        // blink LED on Nucleo board when done
        wait(0.5);
        myled = !myled;
    }
}
