/**
 * @file main.cpp
 * @brief 新入生教育用Xbee送受信プログラム
 * 
 * <table><tr><th> 送信(PC->mbed) </th><th>  受信(mbed->PC)      </th></tr>
 *        <tr><th>  's' or 'S'   </th><th>  "Mission Start"     </th></tr>
 *        <tr><th>  't' or 'T'   </th><th>  任意の文字列 (注1)</th></tr>
 *        <tr><th>  'c' or 'C'   </th><th>  "Mission complete"  </th></tr>
 * </table>
 * 
 * (注1) 't' または 'T' を入力した後，任意の文字列を入力しエンターキーを押すと，その文字列がmbedからPCに送信される．
 *
 * @author Shuhei Kayawari
 * @date 2018/06/13
 */

#include "mbed.h"

Serial pc(USBTX, USBRX);
Serial xbee(PA_9, PA_10);

int main()
{    
    pc.printf("XBee Start\r\n");
    xbee.printf("XBee Connected\r\n");
    
    while(1) {
        pc.printf("Waiting for data...\r\n");

        int received_data = xbee.getc();
        
        pc.printf("Received Data: %c\r\n", received_data);

        if(received_data == 83 || received_data == 115) { //S or s
            xbee.printf("%c\r\n", received_data);
            xbee.printf("Mission Start\r\n");
        } else if(received_data == 84 || received_data == 116) { //T or t
            xbee.printf("%c\r\n", received_data);
            
            char str[1024] = {};
            int i = 0;
            
            do
                str[i++] = xbee.getc();
            while(str[i-1] != 0x0d);
            
            xbee.printf("%s\r\n", str);
        }
        else if(received_data == 67 || received_data == 99) { //C or c
            xbee.printf("%c\r\n", received_data);
            xbee.printf("Mission Complete\r\n");
        }
    }
    
    return 0;
}
