#include "mbed.h"
#include "BMP180.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>


I2C bmp(D4, D5);
BMP180 bmp180(&bmp);
Serial xbee(PA_9, PA_10);
I2C i2c(D4, D5); // sda, scl
#include "SSD1306.h"
DigitalOut led(LED1);
DigitalIn button(A1);
DigitalOut led_button(A2);
const int AQCM0802_addr = 0x7C;

unsigned char mode;
unsigned char contrast = 0; // 0-63
unsigned char contrastFlag = false;
int CGcounter;
int FADEcounter;

void lcd_cmd(char x)
{
    char data[2];
    data[0] = 0x00; // CO = 0,RS = 0
    data[1] = x;
    i2c.write(AQCM0802_addr, data, 2);
}

void lcd_contdata(char x)
{
    char data[2];
    data[0] = 0xC0; //0b11000000 CO = 1, RS = 1
    data[1] = x;
    i2c.write(AQCM0802_addr, data, 2);
}

void lcd_lastdata(char x)
{
    char data[2];
    data[0] = 0x40; //0b11000000 CO = 0, RS = 1
    data[1] = x;
    i2c.write(AQCM0802_addr, data, 2);
}

void lcd_printStr(const char *s)
{
    while(*s) {
        if(*(s + 1)) {
            lcd_contdata(*s);
        } else {
            lcd_lastdata(*s);
        }
        s++;
    }
}

void lcd_printHex(unsigned char num)
{
    lcd_contdata(num);
}

void lcd_init()
{
    wait(0.04);
    // LCD initialize
    lcd_cmd(0x38); // function set
    lcd_cmd(0x39); // function set
    lcd_cmd(0x04); // EntryModeSet
    lcd_cmd(0x14); // interval osc
    lcd_cmd(0x70 | (contrast & 0xF)); // contrast Low
    lcd_cmd(0x5C | ((contrast >> 4) & 0x3)); // contast High/icon/power
    lcd_cmd(0x6C); // follower control
    wait(0.2);
    lcd_cmd(0x38); // function set
    lcd_cmd(0x0C); // Display On
    lcd_cmd(0x01); // Clear Display
    wait(0.2); // need additional wait to Clear Display
}

void lcd_setCursor(unsigned char x,unsigned char y)
{
    lcd_cmd(0x80 | (y * 0x40 + x));
}

void setContrast(unsigned char c)
{
    lcd_cmd(0x39);
    lcd_cmd(0x70 | (c & 0x0f)); // contrast Low
    lcd_cmd(0x5C | ((c >> 4) & 0x03)); // contast High/icon/power
    lcd_cmd(0x38);
}

float get_P()
{
    float sum = 0.0f;
    for(int i=0;i<10;i++){
        bmp180.startPressure(BMP180::ULTRA_LOW_POWER);
        wait_ms(10);    // Wait for conversion to complete
        int pressure;
        if(bmp180.getPressure(&pressure) != 0) {
            printf("Error getting pressure\n");
        }
        sum += pressure;
    }
    return sum/1000.0f;
}

float get_T()
{
    float sum = 0.0f;
    for(int i=0;i<10;i++){
        bmp180.startTemperature();
        wait_ms(5);     // Wait for conversion to complete
        float temp;
        if(bmp180.getTemperature(&temp) != 0) {
            printf("Error getting temperature\n");
        }
        sum += temp;
    }
    return sum/10.0f;
}


int main()
{
    ssd1306_init();
    ssd1306_init_meter_display();
    button.mode(PullUp);
    while(1) {
        if (bmp180.init() != 0) {
            printf("Error communicating with BMP180\n");
        } else {
            printf("Initialized BMP180\n");
            break;
        }
        wait(1);
    }

    char buf[64] = {};
    int buf_count = 0;
    float pressure, temp, ground_P, ground_T, height;
    bool init = false;
    char str_lcd[15];
    char strtmp[15];
    int n;
    lcd_init();
    lcd_setCursor(0,0);
    lcd_printStr("Hello");
    lcd_setCursor(3,1);
    lcd_printStr("SSSRC");
    contrast = 35;
    setContrast(contrast);
    while(1) {
        int timer = 0;
        int bb = button;
        bool deploy = false;
        while(!bb){
            deploy = true;
            led_button = 1;
            if(timer == 0){
                lcd_setCursor(0,0);
                lcd_printStr("55555555");
                lcd_setCursor(0,1);
                lcd_printStr("55555555");
                contrast = 35;
            }else if(timer == 10){
                lcd_setCursor(0,0);
                lcd_printStr("44444444");
                lcd_setCursor(0,1);
                lcd_printStr("44444444");
                contrast = 35;
            }else if(timer == 20){
                lcd_setCursor(0,0);
                lcd_printStr("33333333");
                lcd_setCursor(0,1);
                lcd_printStr("33333333");
                contrast = 35;
            }else if(timer == 30){
                lcd_setCursor(0,0);
                lcd_printStr("22222222");
                lcd_setCursor(0,1);
                lcd_printStr("22222222");
                contrast = 35;
            }else if(timer == 40){
                lcd_setCursor(0,0);
                lcd_printStr("11111111");
                lcd_setCursor(0,1);
                lcd_printStr("11111111");
                contrast = 35;
            }else if(timer>=50){
                xbee.printf("O");
                lcd_setCursor(0,0);
                lcd_printStr("CanSat  ");
                lcd_setCursor(0,1);
                lcd_printStr(" Deploy!");
                contrast = 35;
            }
            wait(0.1);
            timer++;
            bb = button;
        }
        if(deploy){
            lcd_setCursor(0,0);
            lcd_printStr("        ");
            lcd_setCursor(0,1);
            lcd_printStr("        ");
            contrast = 35;
        }
        led_button = 0;
        //buf[0] = '0';
        int nosignal = 0;
        bool push = false;
        while(xbee.readable()==0) {
            xbee.printf("G");
            nosignal++;
            bb = button;
            if(nosignal == 5000){
                lcd_setCursor(0,0);
                lcd_printStr("NoSignal");
                lcd_setCursor(0,1);
                lcd_printStr("        ");
                contrast = 35;  
            }else if(!bb && nosignal<5000){
                push = true;
                break;   
            }
        }
        if(push){
            printf("1");
            continue;
        }
        while(1) {
            int c = xbee.getc();
            //printf("%c",c);
            if(buf_count == 0 && c != 'P') {
                continue;
            }
            buf[buf_count] = c;
            buf_count++;
            if(c == '\n') {
                buf[buf_count] = '\0';
                printf("buf:%s\r\n",buf);
                sscanf(buf,"PP%fT%f\n", &pressure, &temp);
                pressure += 1.77f;
                buf_count = 0;
                while(xbee.readable()==1) {
                    c = xbee.getc();
                }
                push = false;
                for(int i=0;i<8;i++){
                    bb = button;
                    if(!bb){
                        led_button = 1;
                        push = true;
                        break;
                    }
                    wait(0.1);
                }
                if(push){
                    printf("2");
                    break;
                }
                led = 1;
                for(int i=0;i<2;i++){
                    bb = button;
                    if(!bb){
                        led_button = 1;
                        push = true;
                        break;
                    }
                    wait(0.1);
                    led = !led;
                }
                led = 0;
                if(push){
                    printf("3");
                    break;
                }
                ground_P = get_P();
                ground_T = get_T();
                //height = ( pow(ground_P/pressure, 1/5.257f)-1 )*(temp+273.15f)/0.0065f;
                height = 290*((temp+ground_T)/2+273.15f)/9.80665f*log(ground_P/pressure);
                if(init) {
                printf("P0=%f P=%f T=%f     B-G=%f\r\n--------------------\r\n",ground_P,pressure,temp,pressure-ground_P);
                    if(height<-100 or height>1000) continue;
                    if(pressure-ground_P>0) height=0.0;
                    sprintf(str_lcd,"%.1fhPa",ground_P-pressure);
                    n=8-strlen(str_lcd);
                    for(int i=0; i<n; i++) {
                        sprintf(strtmp," %s",str_lcd);
                        sprintf(str_lcd,"%s",strtmp);
                    }
                    lcd_setCursor(0,0);
                    lcd_printStr(str_lcd);
                    printf("%s\r\n",str_lcd);

                    sprintf(str_lcd,"%.1f""\xf2""C",ground_T);
                    n=8-strlen(str_lcd);
                    for(int i=0; i<n; i++) {
                        sprintf(strtmp," %s",str_lcd);
                        sprintf(str_lcd,"%s",strtmp);
                    }
                    
                    lcd_setCursor(0,1);
                    lcd_printStr(str_lcd);
                    contrast = 35;
                    setContrast(contrast);
                    printf("%s\r\n\r\n",str_lcd);
                    printf("height=%f m\r\n",height);
                    ssd1306_draw_meter( (int)height );
                }
                init = true;
                printf("P0=%f P=%f T=%f     B-G=%f\r\n--------------------\r\n",ground_P,pressure,temp,pressure-ground_P);
            }
            break;
        }
    }
}
