#include "mbed.h"
#include "BMP180.h"
#include <stdio.h>


I2C i2c(D4, D5);
BMP180 bmp180(&i2c);
Serial xbee(PA_9, PA_10);
DigitalOut led(LED1);
PwmOut servo(A1);
float calc(float);

float get_P()
{
    float sum = 0.0f;
    for(int i=0;i<10;i++){
        bmp180.startPressure(BMP180::ULTRA_LOW_POWER);
        wait_ms(10);    // Wait for conversion to complete
        int pressure;
        if(bmp180.getPressure(&pressure) != 0) {
            printf("Error getting pressure\n");
        }
        sum += pressure;
    }
    return sum/1000.0f;
}

float get_T()
{
    float sum = 0.0f;
    for(int i=0;i<10;i++){
        bmp180.startTemperature();
        wait_ms(5);     // Wait for conversion to complete
        float temp;
        if(bmp180.getTemperature(&temp) != 0) {
            printf("Error getting temperature\n");
        }
        sum += temp;
    }
    return sum/10.0f;
}



int main()
{
    while(1) {
        if (bmp180.init() != 0) {
            printf("Error communicating with BMP180\n");
        } else {
            printf("Initialized BMP180\n");
            break;
        }
        wait(1);
    }
    float temp, pressure;
    while(1) {
        servo = 0.0;
        if(xbee.readable()==0) {
            wait(0.1);
            continue;
        }
        char c = xbee.getc();
        if(c == 'G') {
            temp = get_T();
            pressure = get_P();
            xbee.printf("P%04.6fT%02.6f\n", pressure, temp);
            printf("P%04.6fT%02.6f\n", pressure, temp);
        }else if(c == 'O'){
            led = 1;
            servo.pulsewidth(0.002);
            for(int i = 1;i<10;i++){
                led = !led;
                wait(0.1);
            }
        }
        led = 0;
        wait(1);
    }
}

float calc(float x)
{
    return (1.45+(2.4-0.5)/180*x)/1000;
}
