#include "mbed.h"
#include "BAROMETER.h"

Timer t;                         //時間計測
Serial pc(USBTX, USBRX);         //シリアル通信
BAROMETER bar(p9, p10 ,0xB8);

//LPS33HW slave address
#define S_add 0xB8

//Check adress
#define WHO_AM_I 0x0F

//CTRL_REG1
#define CTRL_REG1 0x10

//Start Up
#define Normal 0x10             //normal(1Hz)
#define High_rate 0x50          //High rate(75Hz)

//data register
#define press_msb 0x2A
#define press_lsb 0x29
#define press_xlsb 0x28

//main program
int main(){
    unsigned long  M, L, XL;
    char ID;
    double press;
    double P;
    
    pc.baud(460800);                           //ボーレート変更
    
    //Communication Check
    ID = bar.i2c_read(WHO_AM_I);
    pc.printf("ID = 0x%x\r\n", ID);
    
    //Start Up
    bar.i2c_write(CTRL_REG1, High_rate);
    
    int i = 0,j = 0;                           //変数
    int k = 100;                              //データ点数  
    double data[k];                            //data配列
    double T[k];                               //Time配列
    
    t.start();                                 //timer Start
    
    pc.printf("Start");
    while(j < 10)
    {
        while(i < k)
        {
        //data read
            M = bar.i2c_read(press_msb);
            L = bar.i2c_read(press_lsb);
            XL = bar.i2c_read(press_xlsb);
            
            press = (M << 16) | (L << 8) | XL;
            
            wait(0.005);
            P = press/4096;
            data[i] = P;      
            T[i] = t.read();
      
            i++;
        }
        
        i = 0;      
        
        //データ出力
        while(i < k)
        {
            pc.printf("%lf , %lf\r\n", T[i], data[i]);
            i++;
        }
        
        i = 0;
        j++;
    }
        
    t.stop();                                   //timer Stop
    pc.printf("finish!\r\n");
    
}
