/* AK9250_magはAKの地磁気データを取得するためのコード */
/* 長くなるので，他のデータ取得について最初は分けておく． */

#include "mbed.h"

LocalFileSystem local("local");
Serial pc (USBTX, USBRX);
I2C i2c(p28, p27);
Timer t;

//AK9250 Slave address
#define ADDR_MPU 0xD2
#define ADDR_AK  0x18

#define MPU_MAG_INT 0x37

//AK9250 registers
#define AK_WHO  0x00
#define AK_DATA 0x03
#define AK_CNTL1  0x0A
#define AK_8Hz    0x12
#define AK_100Hz  0x16
#define ST1       0x02
#define ST2       0x

char cmd[2];

void i2c_write(char addr, char regist, char data)
{
    cmd[0] = regist;
    cmd[1] = data;
    i2c.write(addr, cmd, 2);
}

char i2c_read(char addr, char regist)
{
    cmd[0] = regist;
    i2c.write(addr, cmd, 1);
    i2c.read(addr, cmd, 1);
    return cmd[0];
}

int main()
{
    //mag val
    char id[2], data[6];
    uint8_t ST1Bit;
    unsigned long ID;
    int16_t mx, my, mz;
    float magx, magy, magz;
    
    //file val
    int i = 0, k = 1000;
    float X[k], Y[k], Z[k];
    float T[k];
    
    //mag start
    i2c_write(ADDR_MPU, MPU_MAG_INT, 0x02);
    
    //mag ID
    ID = i2c_read(ADDR_AK, AK_WHO);
    pc.printf("ID = 0x%x\n", ID);
    
    //gyro range setup
    i2c_write(ADDR_AK, AK_CNTL1, AK_100Hz);
    wait(0.5);
    
    t.start();
    
    while(i < k)
    {
        ST1Bit = i2c_read(ADDR_AK, ST1);
        
        if((ST1Bit & 0x01))
        {
            id[0] = AK_DATA;
            i2c.write(ADDR_AK, id, 1);
            i2c.read(ADDR_AK, data, 7);
        }
        
        mx = (data[1] << 8) | data[0];
        my = (data[3] << 8) | data[2];
        mz = -((data[5] << 8) | data[4]);
        
        magx = mx * 4800.0f / 32768; //[ut]に変換している
        magy = my * 4800.0f / 32768; //同様
        magz = mz * 4800.0f / 32768; //同様
        
        X[i] = magx;
        Y[i] = magy;
        Z[i] = magz;
        T[i] = t.read();
        
        i++;
        
        /* Serial PC
        pc.printf("time = %f\r\n", t.read());
        pc.printf("magx = %lf [ut]\r\n", magx);
        pc.printf("magy = %lf [ut]\r\n", magy);
        pc.printf("magz = %lf [ut]\r\n", magz);
        */
        
        //wait(1);
    }
    
    t.stop();
    
    //データ保存
    pc.printf("Save start!\n");
    
    FILE *fp;
    
    fp = fopen("/local/mag.csv", "w");
    
    for(i=0; i<k; i++)
    {
        fprintf(fp, "%f, %f, %f, %f\n", T[i], X[i], Y[i], Z[i]);
        wait(0.005);
    }
    
    fclose(fp);
    
    pc.printf("finish!");

}
