/* MPU9250_gyroはMPUのジャイロデータを取得するためのコード */
/* 長くなるので，他のデータ取得について最初は分けておく． */

#include "mbed.h"

LocalFileSystem local("local");
Serial pc (USBTX, USBRX);
I2C i2c(p28, p27);
Timer t;

//MPU9250 Slave address
#define ADDR_MPU 0xD2

//MPU9250 registers
#define MPU_WHO  0x75
#define MPU_PWR  0x6B
#define MPU_DATA 0x3B

//MPU9250 gyro setup register
#define gyro_CONFIG  0x1b
#define gyro_250DPS  0x00
#define gyro_500DPS  0x08
#define gyro_1000DPS 0x10
#define gyro_2000DPS 0x18


char cmd[2];

void i2c_write(char addr, char regist, char data)
{
    cmd[0] = regist;
    cmd[1] = data;
    i2c.write(addr, cmd, 2);
}

char i2c_read(char addr, char regist)
{
    cmd[0] = regist;
    i2c.write(addr, cmd, 1);
    i2c.read(addr, cmd, 1);
    return cmd[0];
}

int main()
{
    //gyro val
    char id[2], data[14];
    unsigned long ID;
    int16_t gx, gy, gz;
    float gyrox, gyroy, gyroz;
    float gyrorange = 250;
    
    //file val
    int i = 0, k= 1000;
    float X[k], Y[k], Z[k];
    float T[k];

    ID = i2c_read(ADDR_MPU, MPU_WHO);
    pc.printf("ID = 0x%x\r\n", ID);

    //MPU9250 gyro&gyro start
    i2c_write(ADDR_MPU, MPU_PWR, 0x00);
    wait(0.5);
    
    //gyro range setup
    i2c_write(ADDR_MPU, gyro_CONFIG, gyro_250DPS);
    
    t.start();
    
    while(i < k)
    {
        id[0] = MPU_DATA;
        i2c.write(ADDR_MPU, id, 1);
        i2c.read(ADDR_MPU, data, 14);
        gx = (data[8] << 8) | data[9];
        gy = (data[10] << 8) | data[11];
        gz = (data[12] << 8) | data[13];
    
        gyrox = gx * gyrorange / 32768.0;
        gyroy = gy * gyrorange / 32768.0;
        gyroz = gz * gyrorange / 32768.0;
        
        X[i] = gyrox;
        Y[i] = gyroy;
        Z[i] = gyroz;
        T[i] = t.read();
        
        i++;
        
        /* Serial PC
        pc.printf("time = %f\r\n", t.read());
        pc.printf("gx = %lf [deg/s]\r\n", gyrox);
        pc.printf("gy = %lf [deg/s]\r\n", gyroy);
        pc.printf("gz = %lf [deg/s]\r\n", gyroz);
        */
        
        //wait(1);
    }
    
    t.stop();
    
    //データ保存
    pc.printf("Save start!\n");
    
    FILE *fp;
    
    fp = fopen("/local/gyro.csv", "w");
    
    for(i=0; i<k; i++)
    {
        fprintf(fp, "%f, %f, %f, %f\n", T[i], X[i], Y[i], Z[i]);
        wait(0.005);
    }
    
    fclose(fp);
    
    pc.printf("finish!");

}
