/* MPU9250_angleはMPUのジャイロ・加速度データを取得するためのコード */

#include "mbed.h"

Serial pc (USBTX, USBRX);
I2C i2c(p28, p27);
Timer t;

//MPU9250 Slave address
#define ADDR_MPU 0xD2

//MPU9250 registers
#define MPU_WHO  0x75
#define MPU_PWR  0x6B
#define MPU_DATA 0x3B

//MPU9250 accel setup register
#define ACCEL_CONFIG 0x1c
#define ACCEL_2G     0x00
#define ACCEL_4G     0x08
#define ACCEL_8G     0x10
#define ACCEL_16G    0x18

//MPU9250 gyro setup register
#define gyro_CONFIG  0x1b
#define gyro_250DPS  0x00
#define gyro_500DPS  0x08
#define gyro_1000DPS 0x10
#define gyro_2000DPS 0x18


char cmd[2];

void i2c_write(char addr, char regist, char data)
{
    cmd[0] = regist;
    cmd[1] = data;
    i2c.write(addr, cmd, 2);
}

char i2c_read(char addr, char regist)
{
    cmd[0] = regist;
    i2c.write(addr, cmd, 1);
    i2c.read(addr, cmd, 1);
    return cmd[0];
}

int main()
{
    //gyro val
    char id[2], data[14];
    unsigned long ID;
    int16_t ax, ay, az;
    float accx, accy, accz;
    float accrange = 16.0;
    int16_t gx, gy, gz;
    float gyrox, gyroy, gyroz;
    float gyrorange = 2000;
    
    //file val
    int i = 0, j = 0, k= 800;
    float GX[k], GY[k], GZ[k];
    float AX[k], AY[k], AZ[k];
    float T[k];
    
    pc.baud(460800);

    ID = i2c_read(ADDR_MPU, MPU_WHO);
    pc.printf("ID = 0x%x\r\n", ID);

    //MPU9250 gyro&gyro start
    i2c_write(ADDR_MPU, MPU_PWR, 0x00);
    wait(0.5);
    
    //accel range setup
    i2c_write(ADDR_MPU, ACCEL_CONFIG, ACCEL_16G);
    
    //gyro range setup
    i2c_write(ADDR_MPU, gyro_CONFIG, gyro_2000DPS);
    
    t.start();
    
    while(j < 5)
    {
        
    while(i < k)
    {
        id[0] = MPU_DATA;
        i2c.write(ADDR_MPU, id, 1);
        i2c.read(ADDR_MPU, data, 14);
        ax = (data[0] << 8) | data[1];
        ay = (data[2] << 8) | data[3];
        az = (data[4] << 8) | data[5];
        gx = (data[8] << 8) | data[9];
        gy = (data[10] << 8) | data[11];
        gz = (data[12] << 8) | data[13];
        
        accx = ax * accrange / 32768.0 * 9.81;
        accy = ay * accrange / 32768.0 * 9.81;
        accz = az * accrange / 32768.0 * 9.81;
    
        gyrox = gx * gyrorange / 32768.0;
        gyroy = gy * gyrorange / 32768.0;
        gyroz = gz * gyrorange / 32768.0;
        
        AX[i] = accx;
        AY[i] = accy;
        AZ[i] = accz;
        
        GX[i] = gyrox;
        GY[i] = gyroy;
        GZ[i] = gyroz;
        
        T[i] = t.read();
        
        i++;
        
        wait(0.0083);
        
    }
    
    i = 0;
    
    while(i < k)
    {
        pc.printf("%f, %f, %f, %f, %f, %f, %f\n", T[i], AX[i], AY[i], AZ[i], GX[i], GY[i], GZ[i]) ;
              
        i++;
    }
    
    i = 0;
    
    j++;
    }
    
    t.stop();
    
    pc.printf("finish!");
}
