#include "mbed.h"

SPI spi(p5, p6, p7);
DigitalOut cs(p8);

Serial pc(USBTX, USBRX);

int main()
{
    spi.format(7, 0);
    spi.frequency(1000000);
    
    pc.printf("Starting ADC!\n");
    
    while(1)
    {
        cs = 0;
        
        spi.write(0x60);
        
        uint8_t high = spi.write(0x00);
        uint8_t low = spi.write(0x00);
        
        low = (high << 5) | (low >> 2);
        high = high >> 3;
        
        double value = (high << 8) | low;
        
        value = value / 4096 * 5.0;
        
        pc.printf("sensor 0 value = %lf\n", value);
        
        cs = 1;
        
        wait(1);
        
    }
}
