#include "mbed.h"

LocalFileSystem local("local");  // マウントポイントを定義（ディレクトリパスになる）
Timer t;        //時間計測
Serial pc(USBTX, USBRX);
I2C i2c(p9, p10);   //sda,scl

//LPS33HW slave address
#define S_add 0xB8

//Check adress
#define WHO_AM_I 0x0F

//CTRL_REG1
#define CTRL_REG1 0x10

//Start Up
#define Normal 0x10             //normal(1Hz)
#define High_rate 0x50          //High rate(75Hz)

//data register
#define press_msb 0x2A
#define press_lsb 0x29
#define press_xlsb 0x28

//define function
char cmd[2];
 
void i2c_write(int addr,char regist,char data)
{
    cmd[0]=regist;
    cmd[1]=data;
    i2c.write(addr,cmd,2);
}
 
char i2c_read(int addr,char regist)
{
    cmd[0]=regist;
    i2c.write(addr,cmd,1);
    i2c.read(addr,cmd,1);
    return cmd[0];
}

//main program
int main(){
    unsigned long  ID, M, L, XL;
    double press;
    double P;
    
    //Communication Check
    ID = i2c_read(S_add, WHO_AM_I);
    pc.printf("ID = 0x%x\r\n", ID);
    
    //Start Up
    i2c_write(S_add, CTRL_REG1, High_rate);        //Start 
    
    int i = 0;                                  //変数
    int k = 500;                                //データ点数  
    double data[k];                           //data
    double T[k];                              //Time
    
    t.start();                                  //timer Start
    
    while(i < k)
    {
    //data read
        M = i2c_read(S_add, press_msb);
        
        L = i2c_read(S_add, press_lsb);
        
        XL = i2c_read(S_add, press_xlsb);
        
        press = (M << 16) | (L << 8) | XL;
        
        wait(0.001);
        
        P = press/4096;
        pc.printf("P = %lf [hPa] \r\n", P);
        data[i] = P;
        T[i] = t.read_ms();
        
        i++;
    }
    
    //データ保存
    pc.printf("Save start!\r\n");
    pc.printf("%lf\r\n",T[99]);
    t.stop();                                   //Timer Stop
    
    FILE *fp;
    
    fp = fopen("/local/pressure.csv", "w");  // ファイルを書き込みモードで開く
    
    for(i = 0 ; i < k ; i++){
        fprintf(fp, "%lf,%lf\n", T[i], data[i]);
        wait(0.01);
    }
    
    fclose(fp);
    
    pc.printf("finish!");
    
}
