#include "mbed.h"

Serial pc(USBTX, USBRX);
I2C i2c(p9, p10);   //sda,scl

//BME680 slave address
#define AD 0xED

//oversampling(t,p),mode
#define Ctrl_meas 0x74
//oversampling(h)
#define Ctrl_hum 0x72

//filter
#define Config 0x75

//data register
#define press_xlsb 0x21
#define press_lsb 0x20
#define press_msb 0x1F




char cmd[2];

void i2c_write(int addr,char regist,char data)
{
    cmd[0]=regist;
    cmd[1]=data;
    i2c.write(addr,cmd,2);
}

char i2c_read(int addr,char regist)
{
    cmd[0]=regist;
    i2c.write(addr,cmd,1);
    i2c.read(addr,cmd,1);
    return cmd[0];
}

int main(){
    char id[2], data[3];
    char iD, XL, L, M;
    double press;
  
    //Communication check
    iD  = i2c_read(AD, 0xD0);
    pc.printf("iD = 0x%x\r\n", iD);
    
    //force mode
    
    while(1)
    {
        //set condition
        i2c_write(AD, Ctrl_meas, 0x05);     //select sampling(T,P) ,mode
        wait(0.5);
        i2c_write(AD, Ctrl_hum, 0x00);      //select sampling h
        wait(0.5);
        
        i2c_write(AD, Config, 0x00);    //select filter
        
        //data read
        M = i2c_read(AD, press_msb);
        
        L = i2c_read(AD, press_lsb);
        
        XL = i2c_read(AD, press_xlsb);
        
        press = (M << 8) | (L << 8) | XL;
        pc.printf("P = %lf\n", press);

    }
}
