#include "mbed.h"

Serial pc (USBTX, USBRX);
I2C i2c(p9, p10);

//BME680 Slave address
#define ADDR_BME 0xED

//LPS331AP registers
#define BME_WHO   0xD0
#define BME_SET1  0x74
#define BME_SET2  0x72
#define BME_P_LL  0x21
#define BME_P_L   0x20
#define BME_P_H   0x1F

char cmd[2];

void i2c_write(char addr, char regist, char data)
{
    cmd[0] = regist;
    cmd[0] = data;
    i2c.write(addr, cmd, 2);
}

char i2c_read(char addr, char regist)
{
    cmd[0] = regist;
    i2c.write(addr, cmd, 1);
    i2c.read(addr, cmd, 1);
    return cmd[0];
}

int main()
{
    unsigned long ID, H, L, XL;
    char id[2], data[3];
    double P;
    
    ID = i2c_read(ADDR_BME, BME_WHO);
    pc.printf("ID = 0x%x\n", ID);

    while(1)
    {
        i2c_write(ADDR_BME, BME_SET1, 0x07);
        wait(0.5);
        i2c_write(ADDR_BME, BME_SET2, 0x00);
        
        H = i2c_read(ADDR_BME, BME_P_H);
        
        L = i2c_read(ADDR_BME, BME_P_L);
        
        XL = i2c_read(ADDR_BME, BME_P_LL);
        
        P = (H << 8) | (L << 8) | XL;
        pc.printf("P = %lf\n", P);
        
        wait(1.0);
        
    }
    
}
