#include "mbed.h"
#include "BAROMETER.h"

BAROMETER::BAROMETER( PinName sda, PinName scl, char adress ) : i2c(sda, scl), _addr(adress)
{
}

BAROMETER::~BAROMETER()
{
}

char BAROMETER::i2c_read(char regist)
{
    char cmd[2];
    cmd[0]=regist;
    i2c.write(_addr,cmd,1);
    i2c.read(_addr,cmd,1);
    return cmd[0];
}

void BAROMETER::i2c_write(char regist,char data)
{
    char cmd[2];
    cmd[0]=regist;
    cmd[1]=data;
    i2c.write(_addr,cmd,2);
}
