#include "mbed.h"
#include "EEPROM.h"
#include "LPS33HW.h"
#include "P7100.h"
#include "MPU9250.h"

Timer t;                                        //時間計測
Serial pc(USBTX, USBRX);
LPS33HW lps(p9, p10);
EEPROM rom(p9, p10);
MPU9250 mpu(p9, p10);
P7100 p7100(p5, p6, p7, p8);
DigitalIn Flight_Pin(p30);

void get_save_low();                     //自作関数プロトタイプ宣言

int pointer_high = 0;                          //EEPROM保存アドレス(high)
int pointer_low = 0;                          //EEPROM保存アドレス(low)


//main
int main()
{
    pc.baud(460800);                           //ボーレート変更
    t.start();                                 //timer Start

    //sensor Setup
    lps.start(1);                           //気圧センサスタート
    lps.start(1);                           //気圧センサスタート
    wait(0.1);
    mpu.start();                            //MPU9250 start&setup
    mpu.accelsetup(3);
    mpu.gyrosetup(3);
    mpu.AKsetup(1);
    wait(0.2);
    
    //wait mode
    pc.printf("waitmode Start!\r\n");
    while(Flight_Pin == 0) {
        get_save_low();                         //data get&save
        wait_ms(1000);
    }
    pc.printf("waitmode Finish!\r\n");
    
}


void get_save_low()
{
    char s[64];                                 //データ取得配列

    float accel[3], gyro[3];                    //MPU9250data
    float AX, AY, AZ, GX, GY, GZ;               //MPU9250data

    float T = t.read();                         //時刻データ取得
    float P = lps.data_read();                  //気圧データ取得
    float V = p7100.v_read();                   //電圧取得
    float TP = 0.25 * V - 0.125;                //タンク圧力換算

    mpu.accel_read(3, accel);
    mpu.gyro_read(3, gyro);
    AX = accel[0];
    AY = accel[1];
    AZ = accel[2];
    GX = gyro[0];
    GY = gyro[1];
    GZ = gyro[2];

    sprintf(s, "%8.3f %8.3f %6.3f %5.3f %5.2f %5.2f %5.2f %5.2f %5.2f\r\n", T, P, TP, AX, AY, AZ, GX, GY, GZ);    //floatからchar*へ変換

    rom.write_low(pointer_low, s, 64);        // write tha data
    pointer_low = pointer_low + 64;          //アドレスずらし

    pc.printf("%s\r\n", s);         //check用

    memset(s, '\0', 64 );                          //初期化
}
