#include "mbed.h"
#include "math.h"
#include "EEPROM.h"
#include "LPS33HW.h"
#include "P7100.h"
#include "MPU9250.h"
#include "GMS6_CR6.h"


Timer t;                                        //時間計測
Serial pc(USBTX, USBRX);
LPS33HW lps(p9, p10);
EEPROM rom(p9, p10);
MPU9250 mpu(p9, p10);
P7100 p7100(p5, p6, p7, p8);
Serial twe(p13, p14);
GMS6_CR6 gps(p28, p27);

DigitalIn Flight_Pin(p30);
DigitalOut ThrustValve(p21);
DigitalOut DepressValve(p22);

void get_save_low();                            //自作関数プロトタイプ宣言
float get_save_high();                           //自作関数プロトタイプ宣言

int pointer_high = 0;                          //EEPROM保存アドレス(high)
int pointer_low = 0;                          //EEPROM保存アドレス(low)



//main
int main()
{
    pc.baud(460800);                           //ボーレート変更
    twe.baud(230400);                          //tweボーレート変更

    float lat_north;                            //GPS緯度
    float lon_east;                             //GPS経度
    float GPS[2];                               //GPSデータ格納配列

    double groundP = 0;                           //地上の気圧データ
    double heightP = 0;                          //高度TBDmの気圧
    double judgeP[5];                           //判定用気圧データ
    double pastP = 0;                            //一つ前の気圧データ
    double dP[5];                                //気圧データの差異
    int judge = 0;                              //判定結果
    int i = 0;                                  //差異配列の番号
    memset(judgeP, 0, 5);
    memset(dP, 1, 5);
    
    int n_dvalve = 0;                            //脱圧バルブの開閉回数

    t.start();                                //timer Start

    //sensor Setup
    lps.start(1);                           //気圧センサスタート
    lps.start(1);                           //気圧センサスタート
    wait(0.1);
    mpu.start();                            //MPU9250 start&setup
    mpu.accelsetup(3);
    mpu.gyrosetup(3);
    mpu.AKsetup(1);
    wait(0.2);

    pc.printf("Power ON!\r\n");

    //地上の気圧取得&計算
    for(int a = 0; a < 1000; a++) {
        groundP = groundP + lps.data_read();
        wait_ms(50);
    }
    groundP = groundP/1000;                   //地上の気圧データ
    heightP = 0.998862 * groundP;             //高度10mの気圧を計算



    //Wait mode
    pc.printf("Wait mode Start!\r\n");
    while(Flight_Pin == 0) {
        get_save_low();                         //data get&save
        wait_ms(1000);
    }
    pc.printf("Wait mode Finish!\r\n");



    //Flight mode
    pc.printf("Flight mode Start!\r\n");

    while(1) {
        for(int k = 0; k < 200; k++) {
            judgeP[i] = 0;                                     //初期化
            for(int n = 0; n < 2; n++) {                    //2回に一回送信
                judgeP[i] = judgeP[i] + get_save_high();                    //data get&save
            }
            twe.printf("^");                                //送信トリガー

            judgeP[i] = judgeP[i]/2;                        //判定用気圧を計算
            dP[i] = judgeP[i] - pastP;                      //差異を取得
            pastP = judgeP[i];                              //判定用気圧値を過去データに置き換える
            i++;
            if(i == 5) {
                i = 0;
            }

            if(dP[0] > 0.05 && dP[1] > 0.05 && dP[2] > 0.05 && dP[3] > 0.05 && dP[4] > 0.05) {                               //空中判定
                if(judgeP[0] > heightP && judgeP[1] > heightP && judgeP[2] > heightP && judgeP[3] > heightP && judgeP[4] > heightP) {         //高度判定
                    judge = 1;
                    break;
                }
            } 
            else if(dP[0] < 0.001 && dP[1] < 0.001 && dP[2] < 0.001 && dP[3] < 0.001 && dP[4] < 0.001) {
                judge = 2;
                break;
            }
        }

        if(judge == 1 || judge == 2) {
            break;   //判定を通過したらループを抜ける
        }

        gps.read(GPS);                                                                    //測位データ取得
        lat_north = GPS[0];
        lon_east = GPS[1];

        if(lat_north > 20 && lat_north < 90 && lon_east > 90 && lon_east < 180) {         //緯度が正常な値のときのみ送信
            twe.printf("%f,%f\r\n^", lat_north, lon_east);                                 //送信トリガー
            pc.printf("%f,%f\r\n", lat_north, lon_east);                                   //check用
        }
        memset(GPS,'\0', 2);                                                                    //送信トリガー
    }

    pc.printf("Flight mode Finish!\r\n");


    //thruster mode
    if(judge == 1) {
        pc.printf("Thruster mode Start!\r\n");
        
        ThrustValve = 1;                                                //スラスタ電磁弁開
        for(int k = 0; k < 250; k++)
        {
            for(int n = 0; n < 2; n++)                                      //2回に一回送信
            {                    
                get_save_high();                    //data get&save
            }
            twe.printf("^");                                            //送信トリガー
        }
        ThrustValve = 0;                                                //スラスタ電磁弁閉
        
        pc.printf("Thruster mode Finish!\r\n");
    }

    //depress mode
    pc.printf("Depress mode Start!\r\n");
    memset(judgeP, 0, 5);
    memset(dP, 1, 5);
    pastP = 0;
    
    while(1) {
        DepressValve = 1;
        
        for(int k = 0; k < 100; k++) {
            judgeP[i] = 0;                                     //初期化
            
            for(int n = 0; n < 2; n++) {                    //2回に一回送信
                judgeP[i] = judgeP[i] + get_save_high();                    //data get&save
            }
            twe.printf("^");                                //送信トリガー

            judgeP[i] = judgeP[i]/2;                        //判定用気圧を計算
            dP[i] = judgeP[i] - pastP;                      //差異を取得
            pastP = judgeP[i];                              //判定用気圧値を過去データに置き換える
            
            if(dP[0] < 0.001 && dP[1] < 0.001 && dP[2] < 0.001 && dP[3] < 0.001 && dP[4] < 0.001 && n_dvalve > 2 || n_dvalve == 10)                 //着地判定      
            {
                judge = 3;
                break;
            }
            i++;
            if(i == 5) {i = 0;}
        }
        
        DepressValve = 0;
        n_dvalve++;
        
        if(judge == 3) {
            break;   //地上判定を通過したらループを抜ける
        }

        gps.read_low(GPS);                                                                    //測位データ取得
        lat_north = GPS[0];
        lon_east = GPS[1];

        if(lat_north > 20 && lat_north < 90 && lon_east > 90 && lon_east < 180) {         //緯度が正常な値のときのみ送信
            twe.printf("%f,%f\r\n^", lat_north, lon_east);                                 //送信トリガー
            pc.printf("%f,%f\r\n", lat_north, lon_east);                                   //check用
        }
        memset(GPS,'\0', 2);                                                                    //送信トリガー
    }
    pc.printf("Depress mode Finish!\r\n");
    
    pc.printf("Recovery mode Start!\r\n");
    pc.printf("Recovery mode Finish!\r\n");



}



void get_save_low()
{
    char s[64];                                 //データ取得配列

    float accel[3], gyro[3];                    //MPU9250data
    float AX, AY, AZ, GX, GY, GZ;               //MPU9250data

    float T = t.read();                         //時刻データ取得
    float P = lps.data_read();                  //気圧データ取得
    float V = p7100.v_read();                   //電圧取得
    float TP = 0.25 * V - 0.125;                //タンク圧力換算

    mpu.accel_read(3, accel);
    mpu.gyro_read(3, gyro);
    AX = accel[0];
    AY = accel[1];
    AZ = accel[2];
    GX = gyro[0];
    GY = gyro[1];
    GZ = gyro[2];

    sprintf(s, "%8.3f %8.3f %6.3f %5.3f %5.2f %5.2f %5.2f %5.2f %5.2f\r\n", T, P, TP, AX, AY, AZ, GX, GY, GZ);    //floatからchar*へ変換

    rom.write_low(pointer_low, s, 64);        // write tha data
    pointer_low = pointer_low + 64;          //アドレスずらし

    pc.printf("%s\r\n", s);         //check用

    memset(s, '\0', 64 );                          //初期化
}

float get_save_high()
{
    char s[64];                                 //データ取得配列

    float accel[3], gyro[3];                    //MPU9250data
    float AX, AY, AZ, GX, GY, GZ;               //MPU9250data

    float T = t.read();                         //時刻データ取得
    float P = lps.data_read();                  //気圧データ取得
    float V = p7100.v_read();                   //電圧取得
    float TP = 0.25 * V - 0.125;                //タンク圧力換算

    mpu.accel_read(3, accel);
    mpu.gyro_read(3, gyro);
    AX = accel[0];
    AY = accel[1];
    AZ = accel[2];
    GX = gyro[0];
    GY = gyro[1];
    GZ = gyro[2];

    sprintf(s, "%8.3f %8.3f %6.3f %5.3f %5.2f %5.2f %5.2f %5.2f %5.2f\r\n", T, P, TP, AX, AY, AZ, GX, GY, GZ);    //floatからchar*へ変換

    rom.write_high(pointer_high, s, 64);        // write tha data

    twe.printf("%s", s);                        //無線機送信

    pointer_high = pointer_high + 64;          //アドレスずらし

    pc.printf("%s\r\n", s);         //check用

    memset(s, '\0', 64 );                          //初期化

    return P;
}
