#include "mbed.h"
#include "EEPROM.h"
#include "LPS33HW.h"
#include "P7100.h"
#include "MPU9250.h"

Timer t;                                    //時間計測
Serial pc(USBTX, USBRX);
LPS33HW lps(p9, p10);
EEPROM rom(p9, p10);
MPU9250 mpu(p9, p10);
P7100 p7100(p5, p6, p7, p8);

void sensor_get_save(int);                     //自作関数プロトタイプ宣言

int pointerAddress = 0;                     //EEPROM保存アドレス

//main
int main()
{
    char data_read[128];
    pc.baud(460800);                           //ボーレート変更
    char ADDR;                                 //アドレス
    
    t.start();                                 //timer Start
    
    pc.printf("Start!");
    
    //Setup
    lps.start(1);                           //気圧センサスタート
    lps.start(1);                           //気圧センサスタート
    wait(0.1);
    mpu.start();                            //MPU9250 start&setup
    mpu.accelsetup(3);
    mpu.gyrosetup(3);
    mpu.AKsetup(1);
    wait(0.2);
    
    
    //data get&save
    for(int n = 0; n <= 4000; n++) {          
        sensor_get_save(n);
        wait_ms(0);
    }


    //read the data
    pointerAddress = 0;
    pc.printf("Data read\r\n");
    
    for(int n = 0; n <= 4000; n++) {
        ADDR = rom.ref_ADDR(n);
        rom.read(ADDR, pointerAddress, data_read, 128);
        wait_ms(5);
        pc.printf("%d, %s", pointerAddress, data_read);
        
        if(pointerAddress == 1000*128){pointerAddress = -128;}
        pointerAddress = pointerAddress + 128;         //アドレスずらし
        memset(data_read, '\0', 128 );                 //初期化
    }


    pc.printf("Finish");
}



void sensor_get_save(int n)
{   
    char s[64];                                 //データ取得配列
    
    float accel[3], gyro[3];           //MPU9250data
    float AX, AY, AZ, GX, GY, GZ;  //MPU9250data
    
    float T = t.read();                    //時刻データ取得
    float P = lps.data_read();             //気圧データ取得
    float v = p7100.v_read();               //電圧取得
    float tp = 0.25 * v - 0.125;            //タンク圧力換算
    
    mpu.accel_read(3, accel);
    mpu.gyro_read(3, gyro);
    AX = accel[0];
    AY = accel[1];
    AZ = accel[2];
    GX = gyro[0];
    GY = gyro[1];
    GZ = gyro[2];

    sprintf(s, "%8.3f %8.3f %6.3f %5.3f %5.2f %5.2f %5.2f %5.2f %5.2f\r\n", T, P, tp, AX, AY, AZ, GX, GY, GZ);    //floatからchar*へ変換
    
    rom.write_high(pointerAddress, s, 64);        // write tha data
    pointerAddress = pointerAddress + 64;          //アドレスずらし
    
    pc.printf("%d, %s\r\n", n, s);         //check用

    memset(s, '\0', 64 );                          //初期化
}
