#include "mbed.h"
#include "EEPROM.h"
#include "LPS33HW.h"
#include "P7100.h"

Timer t;                                    //時間計測
Serial pc(USBTX, USBRX);
LPS33HW lps(p9, p10);            
EEPROM rom(p9, p10);
P7100 p7100(p5, p6, p7, p8);

#define ADDR 0xA0                           //コントロールアドレス？


int pointerAddress = 0;

//main
int main()
{
    int Len, n;
    int h = 30;
    char k[h];
    char data_read[1];
    
    pc.baud(460800);                           //ボーレート変更
    
    t.start();                                 //timer Start
    pc.printf("Start!");
    lps.start(1);                           //気圧センサスタート
    
    for(n = 0; n < 100; n++) {
        double T = t.read();                    //時刻データ取得
        
        double P = lps.data_read();             //気圧データ取得
        
        float v = p7100.v_read();               //電圧取得
        //float tp = 0.25 * v - 0.125;          //タンク圧力換算

        sprintf(k, "%.3f, %.3f, %.3f\r\n", T, P, v);    //floatからchar*へ変換

        Len = strlen(k) + 1;                    //kの文字列の長さを取得
        
        char s[Len];                            //データ格納配列
        
        for(int i = 0; i < Len; i++) {          //EEPROM書込み用配列へ格納
            s[i] = k[i];
        }
        
        // write tha data
        rom.write(ADDR, pointerAddress, s, Len);
        pc.printf("%d, %d, Data written: %s\r\n", n, Len, s);

        pointerAddress = pointerAddress + Len;  //アドレスずらし
        memset(s, '\0' , Len );                //初期化
    }
        
    //read the data
    pointerAddress = 0;
    pc.printf("Data read\r\n");
    
    for(n = 0; n < 3000; n++) {
        rom.read(ADDR, pointerAddress, data_read, 1);
        pc.printf("%s", data_read);
        
        pointerAddress = pointerAddress + 1;
        memset(data_read, '\0' , 1 );                //初期化
    }
    
    pc.printf("Finish");
}