#include "mbed.h"
#include "string.h"
#include "LPS33HW.h"

Timer t;                         //時間計測
I2C i2c(p9, p10);
Serial pc(USBTX, USBRX);
LPS33HW lps(p9, p10);


#define ADDR 0xA0       //コントロールアドレス？

int pointerAddress = 0;

// this function has 63 bytes write limit
void writeEEPROM(char address, unsigned int eeaddress, char *data, int size)        //write関数？
{
    char i2cBuffer[size + 2];
    i2cBuffer[0] = (unsigned char)(eeaddress >> 8); // MSB                          //8bit右シフト 番地の上位アドレス
    i2cBuffer[1] = (unsigned char)(eeaddress & 0x00FF); // LSB                        //bit&  番地の下位アドレス

    for (int i = 0; i < size; i++) {
        i2cBuffer[i + 2] = data[i];                                                 //1byteずつデータ格納
    }

    int result = i2c.write(ADDR, i2cBuffer, size + 2);                              //I2Cアドレス，データ，データのバイト数
    wait_ms(6);
}

// this function has no read limit
void readEEPROM(char address, unsigned int eeaddress, char *data, int size)     //read関数
{
    char i2cBuffer[2];
    i2cBuffer[0] = (unsigned char)(eeaddress >> 8); // MSB
    i2cBuffer[1] = (unsigned char)(eeaddress & 0x00FF); // LSB

    // Reset eeprom pointer address
    int result = i2c.write(ADDR, i2cBuffer, 2);
    wait_ms(6);

    // Read eeprom
    i2c.read(ADDR, data, size);
    wait_ms(6);
}


//main
int main()
{
    int Len, n;
    int h = 30;
    char k[h];
    char data_read[1];
    //pc.baud(460800);                           //ボーレート変更

    //readEEPROM(ADDR, pointerAddress, data_read, h);
    //pc.printf("Previous data stored:%s\r\n", data_read);
    
    t.start();                                 //timer Start

    for(n = 0; n < 100; n++) {
        lps.start(1);                           //気圧センサスタート
        double P = lps.data_read();             //気圧データ取得
        double T = t.read();                    //時刻データ取得

        sprintf(k, "%.3f, %.3f\r\n", T, P);    //floatからchar*へ変換

        Len = strlen(k) + 1;                    //kの文字列の長さを取得
        
        char s[Len];                            //データ格納配列
        
        for(int i = 0; i < Len; i++) {          //EEPROM書込み用配列へ格納
            s[i] = k[i];
        }
        
        // write tha data
        writeEEPROM(ADDR, pointerAddress, s, Len);
        pc.printf("%d, %d, Data written: %s\r\n", n, Len, s);

        pointerAddress = pointerAddress + Len;  //アドレスずらし
        memset(s, '\0' , Len );                //初期化
        wait(0.2);
    }
        
    //read the data
    pointerAddress = 0;
    pc.printf("Data read\r\n");
    
    for(n = 0; n < 3000; n++) {
        readEEPROM(ADDR, pointerAddress, data_read, 1);
        pc.printf("%s", data_read);
        
        pointerAddress = pointerAddress + 1;
        memset(data_read, '\0' , 1 );                //初期化
    }
    
    pc.printf("Finish");
}