#include "mbed.h"
#include "P7100.h"

P7100::P7100(PinName mosi, PinName miso, PinName sclk, PinName pin) : spi(mosi, miso, sclk), cs(pin)
{   
    cs = 0;
    spi.format(7, 0);       //通信形式定義
    spi.frequency(1000000); //クロックレート
}

P7100::~P7100()
{
}

float P7100::v_read()
{
    uint8_t high, low;      //1バイトの符号なし整数
    float value, v;    //値，電圧
    
    cs = 0;             //通信開始
        
    spi.write(0x60);    //シングル
    //spi.write(0x40);  //差動
    
    high = spi.write(0x00);
    low = spi.write(0x00);
    
    low = (high << 5) | (low >> 2);
    high = high >> 3;
    
    value = (high << 8) | low;
    
    v = value / 4096 * 5.0;     //出力電圧

    cs = 1;             //通信終了
    
    return v;
} 