#ifndef MBED_MPU9250_H
#define MBED_MPU9250_H

#include "mbed.h"


//MPU9250 Slave address
#define ADDR_MPU 0xD2

//MPU9250 registers
#define MPU_WHO  0x75
#define MPU_PWR  0x6B
#define MPU_ACCELDATA 0x3B
#define MPU_GYRODATA  0x43

//AK9250 Slave address
#define ADDR_AK  0x18
#define MPU_MAG_INT 0x37

//MPU9250 accel setup register
#define ACCEL_CONFIG 0x1c
#define ACCEL_2G     0x00
#define ACCEL_4G     0x08
#define ACCEL_8G     0x10
#define ACCEL_16G    0x18

//MPU9250 gyro setup register
#define gyro_CONFIG  0x1b
#define gyro_250DPS  0x00
#define gyro_500DPS  0x08
#define gyro_1000DPS 0x10
#define gyro_2000DPS 0x18

//MPU9250 mag setup registers
#define AK_WHO    0x00
#define AK_DATA   0x03
#define AK_CNTL1  0x0A
#define AK_8Hz    0x12
#define AK_100Hz  0x16
#define ST1       0x02


class MPU9250
{
public:
    MPU9250(PinName sda,PinName scl);
    ~MPU9250();
    
    char read(char addr, char regist);                 // 基本read関数
    void write(char addr, char regist,char data);      // 基本write関数
    char who();                                        // WHO_AM_I(MPU)
    char AKwho();                                      // WHO_AM_I(AK)
    void start();                                      // Start，mode0;normal,mode1;high rate
    void accelsetup(char mode);                        // 加速度計の測定範囲選択
    void gyrosetup(char mode);                         // 角速度計の測定範囲選択
    void AKsetup(char mode);                           // 地磁気の測定モード選択
    void accel_read(char mode, float *A);              // 加速度のデータを読み込む
    void gyro_read(char mode, float *G);               // 角速度計のデータを読み込む
    void mag_read(float *M);                           // 地磁気のデータを読み込む
    
private:
    I2C i2c;
    
};

#endif