
#include "mbed.h"
#include "MPU9250.h"

MPU9250::MPU9250(PinName sda,PinName scl) : i2c(sda, scl)
{
}

MPU9250::~MPU9250()
{
}

char MPU9250::read(char addr, char regist)
{   
    char cmd[2];
    cmd[0]= regist;
    i2c.write(addr,cmd,1);
    i2c.read(addr,cmd,1);
    return cmd[0];
}

void MPU9250::write(char addr, char regist,char data)
{
    char cmd[2];
    cmd[0]=regist;
    cmd[1]=data;
    i2c.write(addr,cmd,2);
}

char MPU9250::who()
{   
    char _ID;
    _ID = read(ADDR_MPU, MPU_WHO);
    return _ID;
}

char MPU9250::AKwho()
{
    char _ID;
    _ID = read(ADDR_AK, AK_WHO);
    return _ID;
}

void MPU9250::start()
{
    //MPU9250 gyro&gyro start
    write(ADDR_MPU, MPU_PWR, 0x00);
    
    //mag start
    write(ADDR_MPU, MPU_MAG_INT, 0x02);
    wait(0.5);
    
}

void MPU9250::accelsetup(char mode)
{
    char _mode;
    if(mode == 0){
        _mode = ACCEL_2G;
    }
    else if(mode == 1){
        _mode = ACCEL_4G;
    }
    else if(mode == 2){
        _mode = ACCEL_8G;
    }
    else if(mode == 3){
        _mode = ACCEL_16G;
    }
    
    write(ADDR_MPU, ACCEL_CONFIG,  _mode);
}

void MPU9250::gyrosetup(char mode)
{
    char _mode;
    if(mode == 0){
        _mode = gyro_250DPS;
    }
    else if(mode == 1){
        _mode = gyro_500DPS;
    }
    else if(mode == 2){
        _mode = gyro_1000DPS;
    }
    else if(mode == 3){
        _mode = gyro_2000DPS;
    }
    
    write(ADDR_MPU, gyro_CONFIG, _mode);
}

void MPU9250::AKsetup(char mode)
{
    char _mode;
    if(mode == 0){
        _mode = AK_8Hz;
    }
    else if(mode == 1){
        _mode = AK_100Hz;
    }

    write(ADDR_AK, AK_CNTL1, _mode);
}

void MPU9250::accel_read(char mode, float *A)
{
    char id[2], data[6];
    int16_t ax, ay, az;
    char _mode;
    float accx, accy, accz;
    
    if(mode == 0){
        _mode = 2;
    }
    else if(mode == 1){
        _mode = 4;
    }
    else if(mode == 2){
        _mode = 8;
    }
    else if(mode == 3){
        _mode = 16;
    }
    
    id[0] = MPU_ACCELDATA;
    i2c.write(ADDR_MPU, id, 1);
    i2c.read(ADDR_MPU, data, 6);
    ax = (data[0] << 8) | data[1];
    ay = (data[2] << 8) | data[3];
    az = (data[4] << 8) | data[5];
    
    accx = ax * _mode / 32768.0 * 9.81;  //[m/s^2]に変換
    accy = ay * _mode / 32768.0 * 9.81;  //同様
    accz = az * _mode / 32768.0 * 9.81;  //同様
    
    *A = accx;
    *(A+1) = accy;
    *(A+2) = accz;

}

void MPU9250::gyro_read(char mode, float *G)
{
    char id[2], data[6];
    int16_t gx, gy, gz;
    char _mode;
    float gyrox, gyroy, gyroz;

    
    if(mode == 0){
        _mode = 250;
    }
    else if(mode == 1){
        _mode = 500;
    }
    else if(mode == 2){
        _mode = 1000;
    }
    else if(mode == 3){
        _mode = 2000;
    }
    
    id[0] = MPU_GYRODATA;
    i2c.write(ADDR_MPU, id, 1);
    i2c.read(ADDR_MPU, data, 6);
    gx = (data[0] << 8) | data[1];
    gy = (data[2] << 8) | data[3];
    gz = (data[4] << 8) | data[5];
    
    gyrox = gx * _mode / 32768.0;       //[deg]
    gyroy = gy * _mode / 32768.0;
    gyroz = gz * _mode / 32768.0;
    
    *G = gyrox;
    *(G+1) = gyroy;
    *(G+2) = gyroz;

}

void MPU9250::mag_read(float *M)
{
    char id[2], data[6];
    uint8_t ST1Bit;
    int16_t mx, my, mz;
    float magx, magy, magz;

    ST1Bit = read(ADDR_AK, ST1);    //mag read bit
        
    if((ST1Bit & 0x01))
    {
        id[0] = AK_DATA;
        i2c.write(ADDR_AK, id, 1);
        i2c.read(ADDR_AK, data, 7);
     }
        
    my = (data[1] << 8) | data[0];
    mx = (data[3] << 8) | data[2];
    mz = -((data[5] << 8) | data[4]);
        
    magx = mx * 4800.0f / 32768; //[ut]に変換している
    magy = my * 4800.0f / 32768; //同様
    magz = mz * 4800.0f / 32768; //同様
        
    *M = magx;
    *(M+1) = magy;
    *(M+2) = magz;
        
}