#ifndef MBED_LPS33HW_H
#define MBED_LPS33HW_H

#include "mbed.h"

//LPS33HW slave address
#define SL_add 0xB8
#define SH_add 0xBA

//Check adress
#define WHO_AM_I 0x0F

//CTRL_REG1
#define CTRL_REG1 0x10

//Start Up
#define Normal 0x10             //normal(1Hz)
#define High_rate 0x50          //High rate(75Hz)

//data register
#define press_msb 0x2A
#define press_lsb 0x29
#define press_xlsb 0x28

class LPS33HW
{
public:
    LPS33HW(PinName sda,PinName scl);
    ~LPS33HW();
    
    char read(char regist);                 //基本read関数
    void write(char regist,char data);      //基本write関数
    char who();                             //WHO_AM_I
    void start(char mode);                  //Start，mode0;normal,mode1;high rate
    double data_read();                     //pressure read
    
private:
    I2C i2c;
    char addr;
};

#endif

