#include "mbed.h"
#include "LPS33HW.h"

LPS33HW::LPS33HW(PinName sda,PinName scl) : i2c(sda, scl) ,addr(SH_add)
{
}

LPS33HW::~LPS33HW()
{
}

char LPS33HW::read(char regist)
{   
    char cmd[2];
    cmd[0]= regist;
    i2c.write(addr,cmd,1);
    i2c.read(addr,cmd,1);
    return cmd[0];
}

void LPS33HW::write(char regist,char data)
{
    char cmd[2];
    cmd[0]=regist;
    cmd[1]=data;
    i2c.write(addr,cmd,2);
}

char LPS33HW::who()
{   
    char _ID;
    _ID = read(WHO_AM_I);
    return _ID;
}

void LPS33HW::start(char mode)
{   
    char _mode;
    if(mode == 0){
        _mode = Normal;
    }
    else if(mode == 1){
        _mode = High_rate;
    }
    
    write(CTRL_REG1, _mode);
}

double LPS33HW::data_read()
{
    unsigned long  M, L, XL;
    double press;
    double P;
    
    M = read(press_msb);
    L = read(press_lsb);
    XL = read(press_xlsb);
    
    press = (M << 16) | (L << 8) | XL;
    P = press/4096;
    
    return P;
}
    