#include "mbed.h"
#include "GMS6_CR6.h"
#include "math.h"

GMS6_CR6::GMS6_CR6(PinName tx,  PinName rx) : gps(tx, rx)
{
}

GMS6_CR6::~GMS6_CR6()
{
}

float GMS6_CR6::_DMS2DEG(float raw_data)     
{
    int d = (int)(raw_data/100);
    float m = (raw_data - (float)d * 100);
    return (float) d + m /60;
}


void GMS6_CR6::read(float *G)
{
    char  gps_data[256];
    memset(gps_data, '\0', 256);
    
    int cnt_gps = 0;
    
    float world_time;
    int rlock, sat_num;
    char lat, lon;
    
    float lon_east = 0;
    float lat_north = 0;
    int i = 0;
    
    while(lat_north < 20 && i < 1000000)                        //緯度が20度以上と測定されるまたは一定回数ループが回ると抜ける
    {   
        if(gps.readable())
        {
            gps_data[cnt_gps] = gps.getc();
            
            if(gps_data[cnt_gps] == '$' || cnt_gps == 256)
            {
                cnt_gps = 0;
                memset(gps_data, '\0', 256); //この関数なんや
            }
            else if(gps_data[cnt_gps] == '\r')
            {   
                if(sscanf(gps_data, "GPGGA,%f,%f,%c,%f,%c,%d,%d", &world_time, &lat_north, &lat, &lon_east, &lon, &rlock, &sat_num) >= 1)
                {
                    if (rlock == 1)
                    {
                        lat_north = _DMS2DEG(lat_north);
                        lon_east = _DMS2DEG(lon_east);
                    }
                }
            }
            else
            {
                cnt_gps++;
            }
        }
        i++;
    }
        
    if(lat_north > 20 && lat_north < 90 && lon_east > 90 && lon_east < 180)           //緯度が正常な値のときのみ値を返す
    {
        *G = lat_north;
        *(G+1) = lon_east;
    }
    else
    {
        *G = 4;
        *(G+1) = 4;
    }
}

void GMS6_CR6::read_solid(float *G)
{
    char  gps_data[256];
    memset(gps_data, '\0', 256);
    
    int cnt_gps = 0;
    
    float world_time;
    int rlock, sat_num;
    char lat, lon;
    
    float lon_east = 0;
    float lat_north = 0;
    unsigned int i = 0;
    
    while(lat_north < 20 && i < 10000000)                        //緯度が20度以上と測定されるまたは一定回数ループが回ると抜ける
    {   
        if(gps.readable())
        {
            gps_data[cnt_gps] = gps.getc();
            
            if(gps_data[cnt_gps] == '$' || cnt_gps == 256)
            {
                cnt_gps = 0;
                memset(gps_data, '\0', 256); //この関数なんや
            }
            else if(gps_data[cnt_gps] == '\r')
            {   
                if(sscanf(gps_data, "GPGGA,%f,%f,%c,%f,%c,%d,%d", &world_time, &lat_north, &lat, &lon_east, &lon, &rlock, &sat_num) >= 1)
                {
                    if (rlock == 1)
                    {
                        lat_north = _DMS2DEG(lat_north);
                        lon_east = _DMS2DEG(lon_east);
                    }
                    else
                    {
                        return;
                    }
                }
            }
            else
            {
                cnt_gps++;
            }
        }
        i++;
    }
        
    if(lat_north > 20 && lat_north < 90 && lon_east > 90 && lon_east < 180)           //緯度が正常な値のときのみ値を返す
    {
        *G = lat_north;
        *(G+1) = lon_east;
        return;
    }
    else
    {
        *G = 4;
        *(G+1) = 4;
    }
}