#ifndef MBED_EEPROM_H
#define MBED_EEPROM_H

#include "mbed.h"

#define ADDR00 0xA0         //EEPROM0 前半アドレス
#define ADDR01 0xA8         //EEPROM0後半アドレス

#define ADDR10 0xA2         //1 前半アドレス
#define ADDR11 0xAA         //1 後半アドレス

#define ADDR20 0xA4         //2 前半アドレス
#define ADDR21 0xAC         //2 後半アドレス

#define ADDR30 0xA6         //3 前半アドレス
#define ADDR31 0xAE         //3 後半アドレス


class EEPROM
{
public:
    EEPROM(PinName sda,PinName scl);
    ~EEPROM();
    
    void write(char address, unsigned int eeaddress, char *data, int size);                 //基本write関数
    void read(char address, unsigned int eeaddress, char *data, int size);                  //基本read関数
    void write_high(unsigned int eeaddress, char *data, int size);                          //Highrate mode write関数
    void write_low(unsigned int eeaddress, char *data, int size);                           //lowrate mode write関数
    char ref_ADDR(int n);                                                                       //読み込みor書込み回数nに対してアドレスを返す関数
    
private:
    I2C i2c;
};

#endif 