#include "mbed.h"
#include "EEPROM.h"
#include "string.h"

EEPROM::EEPROM(PinName sda,PinName scl) : i2c(sda, scl)
{
    i2c.frequency(1000000);
}

EEPROM::~EEPROM()
{
}

void EEPROM::write(char address, unsigned int eeaddress, char *data, int size)        //i2cアドレス，EEPROM番地，データ，サイズ
{
    char i2cBuffer[size + 2];
    i2cBuffer[0] = (unsigned char)(eeaddress >> 8); // MSB                            //8bit右シフト 番地の上位アドレス
    i2cBuffer[1] = (unsigned char)(eeaddress & 0x00FF); // LSB                        //bit&  番地の下位アドレス

    for (int i = 0; i < size; i++) {
        i2cBuffer[i + 2] = data[i];                                                   //1byteずつデータ格納
    }

    int result = i2c.write(address, i2cBuffer, size + 2);                              //I2Cアドレス，データ，データのバイト数
    wait_ms(6);
}

void EEPROM::read(char address, unsigned int eeaddress, char *data, int size)         //i2cアドレス，EEPROM番地，データ，サイズ
{
    char i2cBuffer[2];
    i2cBuffer[0] = (unsigned char)(eeaddress >> 8);                                     // MSB
    i2cBuffer[1] = (unsigned char)(eeaddress & 0x00FF);                                 // LSB

    // Reset eeprom pointer address
    int result = i2c.write(address, i2cBuffer, 2);                                      //アドレス指定
    wait_ms(6);

    // Read eeprom
    i2c.read(address, data, size);
    wait_ms(6);
}

void EEPROM::write_high(unsigned int eeaddress, char *data, int size)                           
{   
    float p = eeaddress / 128;           //ページ数
    char ADDR;                          //アドレス
    
    if(p <= 500)
    {   ADDR = ADDR00;}
        else if(p <= 1000)
        {   ADDR = ADDR01;
        }
        else if(p <= 1500)
        {   ADDR = ADDR10;
            eeaddress = eeaddress -1000*128;
        }
        else if(p <= 2000)
        {   ADDR = ADDR11;
            eeaddress = eeaddress -1000*128;
        }
        else
        {   return;
        }
    
    write(ADDR, eeaddress, data, size);
}

void EEPROM::write_low(unsigned int eeaddress, char *data, int size)
{
    
    float p = eeaddress / 128;           //ページ数
    char ADDR;                          //アドレス
    
    if(p <= 500)
    {   ADDR = ADDR20;}
        else if(p <= 1000)
        {   ADDR = ADDR21;
        }
        else if(p <= 1500)
        {   ADDR = ADDR30;
            eeaddress = eeaddress -1000*128;
        }
        else if(p <= 2000)
        {   ADDR = ADDR31;
            eeaddress = eeaddress -1000*128;
        }
        else
        {   return;
        }
    
    write(ADDR, eeaddress, data, size);
}

char EEPROM::ref_ADDR(int n)                //n:ページ数
{   
    char ADDR;
    
    if(n <= 500)
    {ADDR = ADDR00;}
        else if(n <= 1000)
        {   ADDR = ADDR01;
        }
        else if(n <= 1500)
        {   ADDR = ADDR10;
        }
        else if(n <= 2000)
        {   ADDR = ADDR11;
        }
        else if(n <= 2500)
        {   ADDR = ADDR20;
        }
        else if(n <= 3000)
        {   ADDR = ADDR21;
        }
        else if(n <= 3500)
        {   ADDR = ADDR30;
        }
        else if(n <= 4000)
        {   ADDR = ADDR31;
        }
                
    return ADDR;
}
