#include "mbed.h"
 
I2C i2c(p9, p10);
Serial pc(USBTX, USBRX);

#define ADDR 0xA0

int pointerAdddress = 0;
char s[10];
 
 
// this function has 63 bytes write limit
void EEPROM_write(char address, unsigned int eeaddress, char *data, int size)
{
    char i2cBuffer[size + 2];
    i2cBuffer[0] = (unsigned char)(eeaddress >> 8); // MSB
    i2cBuffer[1] = (unsigned char)(eeaddress & 0xFF00); // LSB
 
    for (int i = 0; i < size; i++) {
        i2cBuffer[i + 2] = data[i];
    }
 
    int result = i2c.write(ADDR, i2cBuffer, size + 2);
    wait_ms(6);
}
 
// this function has no read limit
void EEPROM_read(char address, unsigned int eeaddress, char *data, int size)
{
    char i2cBuffer[2];
    i2cBuffer[0] = (unsigned char)(eeaddress >> 8); // MSB
    i2cBuffer[1] = (unsigned char)(eeaddress & 0xFF00); // LSB
 
    // Reset eeprom pointer address
    int result = i2c.write(ADDR, i2cBuffer, 2);
    wait_ms(6);
 
    // Read eeprom
    i2c.read(ADDR, data, size);
    wait_ms(6);
}
 
int main()
{
    int i, length;
    char data_read[1]; 
    EEPROM_read(ADDR, pointerAdddress, data_read, 1);
    pc.printf("Previous data stored: %s\n", data_read);
    
    while(1)
    {
        
        s[0] = 'a';
        
        // write tha data
        EEPROM_write(ADDR, pointerAdddress, s, 1);
        pc.printf("Data written: %s\n", s);
    
        // read the data
        EEPROM_read(ADDR, pointerAdddress, data_read, 1);
        pc.printf("Data read: %s\n", data_read);
    
        wait(1);
    }
 
}