#include "mbed.h"
#include "string.h"
 
I2C i2c(p28, p27);
Serial pc(USBTX, USBRX);

#define ADDR 0xA0       //コントロールアドレス？

int pointerAdddress = 0;
char s[10];
 
 
// this function has 63 bytes write limit
void writeEEPROM(char address, unsigned int eeaddress, char *data, int size)        //write関数？
{
    char i2cBuffer[size + 2];
    i2cBuffer[0] = (unsigned char)(eeaddress >> 8); // MSB                          //8bit右シフト 番地の上位アドレス
    i2cBuffer[1] = (unsigned char)(eeaddress & 0x00FF); // LSB                        //bit&  番地の下位アドレス
 
    for (int i = 0; i < size; i++) {        
        i2cBuffer[i + 2] = data[i];                                                 //1byteずつデータ格納
    }
 
    int result = i2c.write(ADDR, i2cBuffer, size + 2);                              //I2Cアドレス，データ，データのバイト数
    wait_ms(6);
}
 
// this function has no read limit
void readEEPROM(char address, unsigned int eeaddress, char *data, int size)     //read関数
{
    char i2cBuffer[2];
    i2cBuffer[0] = (unsigned char)(eeaddress >> 8); // MSB
    i2cBuffer[1] = (unsigned char)(eeaddress & 0x00FF); // LSB
 
    // Reset eeprom pointer address
    int result = i2c.write(ADDR, i2cBuffer, 2);
    wait_ms(6);
 
    // Read eeprom
    i2c.read(ADDR, data, size);
    wait_ms(6);
}
 
 
int main()
{
    int i, Len;
    char data_read[10]; 
    
    readEEPROM(ADDR, pointerAdddress, data_read, 1);
    pc.printf("Previous data stored: %s\n", data_read);
    
    while(1)
    {
        float j = -1.2345;
        char* k;
        
        sprintf(k, "%g", j);    //floatからchar*へ変換
        
        Len = strlen(k);        //kの文字列の長さを取得
        
        for(i = 0; i < Len; i++)    //EEPROM書込み用配列へ格納
        {
        s[i] = k[i];
        }
        
        // write tha data
        writeEEPROM(ADDR, pointerAdddress, s, Len);
        pc.printf("Data written: %s\n", s);
    
        // read the data
        readEEPROM(ADDR, pointerAdddress, data_read, Len);
        pc.printf("Data read: %s\n", data_read);
    
        wait(1);
    }
 
}