/* MPU9250のライブラリを使ったコード */

#include "mbed.h"
#include "MPU9250.h"

Serial pc (USBTX, USBRX);
MPU9250 mpu(p28, p27);
Timer t;



int main()
{
    unsigned long ID;
    
    //file value
    int i = 0, j = 0, k= 500;
    float accel[3], gyro[3], mag[3];
    float AX[k], AY[k], AZ[k];
    float GX[k], GY[k], GZ[k];
    float MX[k], MY[k], MZ[k];
    float T[k];
    
    pc.baud(460800);
    
    //accle&gyro ID
    ID = mpu.who();
    pc.printf("ID = 0x%x\r\n", ID);
    
    //mag ID
    ID = mpu.AKwho();
    pc.printf("ID = 0x%x\n", ID);

    //MPU9250 start
    mpu.start();
    
    //accel setup
    mpu.accelsetup(3);
    
    //gyro setup
    mpu.gyrosetup(3);
    
    //mag setup
    mpu.AKsetup(1);
    wait(0.5);
    
    t.start();
    
    while(j < 12)
    {
        
    while(i < k)
    {
        mpu.accel_read(3, accel);
        mpu.gyro_read(3, gyro);
        mpu.mag_read(mag);
         
        AX[i] = accel[0];
        AY[i] = accel[1];
        AZ[i] = accel[2];
        
        GX[i] = gyro[0];
        GY[i] = gyro[1];
        GZ[i] = gyro[2];
        
        MX[i] = mag[0];
        MY[i] = mag[1];
        MZ[i] = mag[2];
        
        T[i] = t.read();
        
        i++;
        
        wait(0.0083);
        
    }
    
    i = 0;
    
    while(i < k)
    {
        pc.printf("%f, %f, %f, %f, %f, %f, %f, %f, %f, %f\n", T[i], AX[i], AY[i], AZ[i], GX[i], GY[i], GZ[i], MX[i], MY[i], MZ[i]) ;
              
        i++;
    }
    
    i = 0;
    
    j++;
    }
    
    t.stop();
    
    pc.printf("finish!");
}
