#include "mbed.h"
#include "EEPROM.h"

EEPROM rom(p9, p10);
Serial pc(USBTX, USBRX);

int pointerAddress = 0;                     //EEPROM保存アドレス

int main()
{
    char data_read[128];
    pc.baud(460800);                           //ボーレート変更
    char ADDR;
    
    pc.printf("Start!");
    
    for(int i = 0;i <= 8000; i++)
    {
    ADDR = rom.ref_ADDR(i/2);
    rom.write(ADDR, pointerAddress, '\0', 64);        // write tha data

    if(pointerAddress == 1000*128){pointerAddress = -128;}
    pointerAddress = pointerAddress + 64;          //アドレスずらし
    }
    
    pointerAddress = 0;
    pc.printf("Data read\r\n");

    for(int n = 0; n <= 8000; n++)
    {
        ADDR = rom.ref_ADDR(n/2);
        rom.read(ADDR, pointerAddress, data_read, 64);
        wait_ms(5);
        pc.printf("%d,%s\r\n", n, data_read);
        
        if(pointerAddress == 1000*128){pointerAddress = -128;}
        pointerAddress = pointerAddress + 64;         //アドレスずらし
        memset(data_read, '\0', 64 );                 //初期化
    }
    pc.printf("Finish!\r\n");
}