#include "mbed.h"

PwmOut mypwm4(D4);
PwmOut mypwm5(D5);
PwmOut mypwm2(D2);
PwmOut mypwm3(D3);


DigitalOut myled2(LED2);
DigitalOut myled3(LED1);


#define STATE_A (0)
#define STATE_B (1)
#define STATE_C (2)
#define STATE_D (3)
#define STATE_E (4)

int main() {
    char mode;
    
    mode = STATE_A;
       
mypwm4.period_ms(10);
mypwm5.period_ms(10);
mypwm2.period_ms(10);
mypwm3.period_ms(10);

switch (mode)
        {
            // STATE_A : 前進（左：正転　右：正転）
            case STATE_A:
                myled2 = 1; // LED2点灯
                myled3 = 1; // LED3点灯
                // 左モータの制御
                mypwm4.pulsewidth_ms(10);
                mypwm5.pulsewidth_ms(0);
                // 右モータの制御
                mypwm2.pulsewidth_ms(10);
                mypwm3.pulsewidth_ms(0);
                break;
                
            // STATE_B : 右旋回（左：正転　右：逆転）
            case STATE_B:
                myled2 = 1; // LED2点灯
                myled3 = 0; // LED3点灯
                // 左モータの制御
                mypwm4.pulsewidth_ms(8);
                mypwm5.pulsewidth_ms(0);
                // 右モータの制御
                mypwm2.pulsewidth_ms(0);
                mypwm3.pulsewidth_ms(8);
                break;
                
            // STATE_C : 左旋回（左：逆転　右：正転）
            case STATE_C:
                myled2 = 0; // LED2点灯
                myled3 = 1; // LED3点灯
                // 左モータの制御
                mypwm4.pulsewidth_ms(0);
                mypwm5.pulsewidth_ms(8);
                // 右モータの制御
                mypwm2.pulsewidth_ms(8);
                mypwm3.pulsewidth_ms(0);
                break;
                
            // STATE_D : 後退（左：逆転　右：逆転）
            case STATE_D:
                myled2 = 1; // LED2点灯
                myled3 = 1; // LED3点灯
                // 左モータの制御
                mypwm4.pulsewidth_ms(0);
                mypwm5.pulsewidth_ms(8);
                // 右モータの制御
                mypwm2.pulsewidth_ms(0);
                mypwm3.pulsewidth_ms(8);
                break;
                
            // STATE_E : ブレーキ（左：ブレーキ　右：ブレーキ）
            case STATE_E:
                myled2 = 0; // LED2点灯
                myled3 = 0; // LED3点灯
                // 左モータの制御
                mypwm4.pulsewidth_ms(8);
                mypwm5.pulsewidth_ms(8);
                // 右モータの制御
                mypwm2.pulsewidth_ms(8);
                mypwm3.pulsewidth_ms(8);
                break;
        }
    
    
    
}