#include "mbed.h"
#include "BufferedSerial.h"
#include "rplidar.h"
#include "Robot.h"
#include "Communication.h"
#include "Functions.h"
#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#define PI 3.141592654

Serial pc(SERIAL_TX, SERIAL_RX);
RPLidar lidar;
BufferedSerial se_lidar(PA_9, PA_10);
PwmOut rplidar_motor(D3);

void bresenham(float poseX, float poseY, float xf, float yf, float z);

float MapaLog[40][40] = {0};
float Mapa40[40][40];

int main() {
    pc.baud(115200);
    init_communication(&pc);
    
    DigitalIn UserButton(USER_BUTTON); // Initialize Button
    DigitalOut myled(LED1); // Initialize LED
    
    // PARAMETROS CONSTANSTES
    float T = 0.01;
    float wheelsRadius = 3.5;
    float wheelsDistance = 13.5;
    
    // Variaveis
    float k_v = 20; // 15
    float k_i = 0.2; //0.1
    float k_s = 8; //20
    float v_erro = 15;
    
    int   DPontos = 3; //distância de erro
    
    float RectSize = 16.0;
    float FCRepul = -8000; // Forca de Repulsao
    float FCAtracao = 0.02; // Forca de Atracao
    
    float pose[3] = {30, 30, 0}; // Ponto Inicial
    float pose_f[3]; // = {130,130,0}; // Ponto Objetivo (definido mais em baixo)
    
    float errot = 0, erro = 0, erro_old = -1;
    float Forcas[4] = {0, 0, 0, 0};
    
    float vRobot, wRobot, Norma, angForca, phi, w[2], ForcaResult[2], PIntermedio[2];
    
    float LidarP[2]; // pontos na plataforma
    float LidarW[2]; // pontos no mundo
    
    // matriz rotacao world plataforma
    float R_WP[3][3]= {{cos(pose[2]), -sin(pose[2]), pose[0]},
                        {sin(pose[2]), cos(pose[2]), pose[1]},
                        {0, 0, 1}};
    
    struct RPLidarMeasurement data;
    
    //Inicializar Mapa das probabilidades a 0.5
    for(int i=0; i<40; i++)
        for(int j=0; j<40; j++)
            Mapa40[i][j]=0.5;
    
    int leituras = 0;
    float dist;
    float r;
    
    // Lidar initialization
    rplidar_motor.period(0.01f);
    //rplidar_motor.write(0.5f);
    lidar.begin(se_lidar);
    lidar.setAngle(0, 360);
            
    
    setSpeeds(0, 0);
    
    pc.printf("wating...\n\r");

    int start = 0;
    while(start != 1) {
        myled=1;
        if (UserButton == 0) { // Button is pressed
            myled = 0;
            start = 1;
            rplidar_motor.write(0.5f);
        }
    }
    
    lidar.startThreadScan();
    
    while(leituras < 1500){
        if(lidar.pollSensorData(&data) == 0)
        {           
            //pc.printf("%f\t%f\n\r", data.distance, data.angle); // Prints one lidar measurement.
            
            float radians = (data.angle * static_cast<float>(PI))/180.0f;
            
            dist = static_cast<float>(data.distance/10.0f); //converte de mm para cm
            
            LidarP[0] = -dist*sin(radians)- 2.8f;
            LidarP[1] = -dist*cos(radians)- 1.5f;

            //W_P = R_WP * p_P
            LidarW[0] = LidarP[0]* R_WP[0][0] + LidarP[1]* R_WP[0][1] + R_WP[0][2]; // coordenadas no mundo, ou seja, cm
            LidarW[1] = LidarP[0]* R_WP[1][0] + LidarP[1]* R_WP[1][1] + R_WP[1][2];
            
            /*if (data.angle > 0 && data.angle < 5){
                pc.printf("Pose[0]: %f Pose[1]: %f Dist: %f Ang: %f LidarP[0]: %f LidarP[1]: %f LidarW[0]: %f LidarW[1]: %f\n\r", pose[0], pose[1], data.distance, data.angle, LidarP[0], LidarP[1], LidarW[0], LidarW[1]);
            }*/
            // pontos onde o feixe passou
            bresenham(pose[0]/5.0f, pose[1]/5.0f, LidarW[0]/5.0f, LidarW[1]/5.0f, dist/5.0f);
            
            leituras++;
        }
        wait(0.01);
    }
    
    //Código para enviar para o matlab
    /*rplidar_motor.write(0.0f);
    for(int i=0; i<40; i++){
        for(int j=0; j<40; j++){
            //pc.printf("%0.3f ", Mapa40[i][j]);
            send_odometry(1, 2, j+1, i+1, Mapa40[j][i],10, 30); // faz prints estranhos no Putty
        }
        //pc.printf("\n\r");
        //pc.printf("\n-----------------------------\n\r");
    }
    
    start = 0;
    while(start != 1) {
        myled=1;
        if (UserButton == 0) { // Button is pressed
            myled = 0;
            start = 1;
        }
    }*/
    
    pc.printf("Running\n\r");
    
    for(int i=0; i<1; i++){
        
        // Pontos ao pe da secretaria do prof
        
        // Primeiro Ponto
        if (i==0){
            pose_f[0] = 160.0f;
            pose_f[1] = 160.0f;
        }
        
        // Segundo Ponto
        /*if (i==1){
            pose_f[0] = 30;
            pose_f[1] = 30;
        }*/
        
        /*// Terceiro Ponto
        if (i==2){
            pose_f[0] = 30;
            pose_f[1] = 30;
        }*/
        
        
        while(sqrt(pow(pose_f[1]-pose[1],2)+pow(pose_f[0]-pose[0],2)) > 8.0f) {
              
            getCountsAndReset(); // Call getCountsAndReset() to read the values of encoders
                                 // and reset them. The values become available on variables
                                 // "countsLeft" and "countsRight".
            
            //if(sqrt(pow(pose_f[1]-pose[1],2)+pow(pose_f[0]-pose[0],2)) > 13){
                
                JanelaAtivaVFF(pose, Mapa40, pose_f, FCRepul, FCAtracao, RectSize, Forcas);
                
                ForcaResult[0] = Forcas[0]+Forcas[2]; // componente de x
                ForcaResult[1] = Forcas[1]+Forcas[3]; // componente de y
        
                Norma = sqrt(pow(ForcaResult[0],2) + pow(ForcaResult[1],2));
                ForcaResult[0] = ForcaResult[0]/Norma; // Normalização da forca resultante entre a forca de repulsão e a forca de atracão
                ForcaResult[1] = ForcaResult[1]/Norma;
        
                // Angulo da forca resultante
                angForca = atan2(ForcaResult[1], ForcaResult[0]);
                
                //pc.printf("FR[0]: %f FR[1]: %f Ang: %f\n\r", ForcaResult[0], ForcaResult[1], angForca);
            //}
            //else
                //angForca = atan2(pose_f[1] - pose[1], pose_f[0] - pose[0]);
            
            
            PIntermedio[0] = pose[0] + v_erro * cos(angForca);
            PIntermedio[1] = pose[1] + v_erro * sin(angForca);
            
            erro = sqrt(pow(PIntermedio[1]-pose[1], 2)+ pow(PIntermedio[0]-pose[0],2)) - DPontos;
            
            if(erro_old == -1){
                erro_old = erro;    
            }
            
            errot = errot + (erro + erro_old) * T/2.0f;
            
            //Velocidade do Robo
            vRobot = k_v * erro + k_i * errot;
            
            erro_old = erro;
            
            phi = atan2((PIntermedio[1]-pose[1]), (PIntermedio[0]-pose[0])); // Angulo entre o ponto intermedio e o robo
            
            wRobot = k_s * atan2(sin(phi-pose[2]), cos(phi-pose[2])); //velocidade angular do robo;
                  
            // Velocidades das rodas
            velRobot2velWheels(vRobot,wRobot,wheelsRadius,wheelsDistance,w);
                    
            // Racio da Velocidade
            r = w[0]/w[1];
            
            // nao permite velocidades menores que 50 e maiores que 100 mantendo o racio
             if(w[0] < 50 || w[1] < 50){
                if (r > 1){
                    w[1] = 50;
                    w[0] = 50*r;
                }
                else if(r < 1){
                    w[0] = 50;
                    w[1] = 50/r;
                }
                else{
                    w[0] = 50;
                    w[1] = 50;
                }
            }
            
            if (w[0] > 100 || w[1] > 100){
                if (r > 1){
                    w[0] = 100;
                    w[1] = 100/r;
                }
                else if(r < 1){
                    w[1] = 100;
                    w[0] = 100*r;  
                }
                else{
                    w[0] = 100;
                    w[1] = 100;
                }
            }
            
            
            /* (w[0] > 200)
                w[0] = 200;
            
            if (w[1] > 200)
                w[1] = 200;*/
                
            setSpeeds(w[0], w[1]);
            
            nextPose(countsLeft, countsRight, wheelsRadius, wheelsDistance, pose);
            
            leituras = 0;
            
            while(leituras < 10){
                if(lidar.pollSensorData(&data) == 0)
                {           
                    //pc.printf("%f\t%f\n\r", data.distance, data.angle); // Prints one lidar measurement.
                    
                    float radians = (data.angle * static_cast<float>(PI))/180.0f;
                    
                    LidarP[0] = -data.distance*sin(radians)- 2.8f;
                    LidarP[1] = -data.distance*cos(radians)- 1.5f;
        
                    //W_P = R_WP * p_P
                    LidarW[0] = LidarP[0]* R_WP[0][0] + LidarP[1]* R_WP[0][1] + R_WP[0][2]; // coordenadas no mundo, ou seja, cm
                    LidarW[1] = LidarP[0]* R_WP[1][0] + LidarP[1]* R_WP[1][1] + R_WP[1][2];
                    
                    // pontos onde o feixe passou
                    bresenham(pose[0]/5, pose[1]/5, LidarW[0]/5, LidarW[1]/5, data.distance/5);
                    
                    leituras++;
                }
            }
                
            wait(T); // Delay of 0.01 seconds.
        }
    }
    
    myled=1;
    setSpeeds(0, 0);
    rplidar_motor.write(0.0f);
    
    /*// Fica a espera do botao
    start = 0;
    while(start != 1) {
        myled=1;
        if (UserButton == 0) { // Button is pressed
            myled = 0;
            start = 1;
        }
    }
    
    //Código para enviar para o matlab
    for(int i=0; i<40; i++){
        for(int j=0; j<40; j++){
            send_odometry(1, 2, j+1, i+1, Mapa40[j][i],10, 30); // faz prints estranhos no Putty
        }
    }*/
    
    
}

void bresenham(float poseX, float poseY, float xf, float yf, float z){
    int T, E, A, B;
    int x = static_cast<int>(poseX);
    int y = static_cast<int>(poseY);
    int dx = abs(static_cast<int>(xf - poseX));
    int dy = abs(static_cast<int>(yf - poseY));
    
    int s1, s2;
    
    if (dx == 0)
        s1 = 0;
    else
        s1 = static_cast<int>((xf - poseX)/dx); // substitui o sign() do matlab
        
    if (dy == 0)
        s2 = 0;
    else
        s2 = static_cast<int>((yf - poseY)/dy);
    
    int interchange = 0;
    
    if (dy > dx){
        T = dx;
        dx = dy;
        dy = T;
        interchange = 1;
    }
    
    E = 2*dy - dx;
    A = 2*dy;
    B = 2*dy - 2*dx;
    
    for (int i = 0; i<dx; i++){
        if (E < 0){
            if (interchange == 1){
                y = y + s2;
            }
            else{
                x = x + s1;
            }
            E = E + A;
        }
        
        else{
            y = y + s2;
            x = x + s1;
            E = E + B;
        }
        
        if (x >= 0 && y >= 0 && x < 40 && y < 40){
            // Mapear mapa do Logaritmo
            MapaLog[y][x] = MapaLog[y][x] + Algorith_Inverse(poseX, poseY, x, y, z);
            //pc.printf("%f %f\n\r", MapaLog[x][y], 1 - 1/(1+exp(MapaLog[x][y])));
            Mapa40[y][x] = 1 - 1/(1+exp(MapaLog[y][x]));
        }
                  
    }
}