#include <math.h>
#include <stdio.h>
#include <stdlib.h>

void JanelaAtivaVFF(float pose[], float Mapa_40[40][40], float poseFinal[], float FCRepul, float FCAtracao, float RectSize, float *ForcaResult)
{
    float x0, y0;
    int cima, baixo, esq, dir;
    
    x0 = static_cast<float>(ceil(pose[0]/5.0f));
    y0 = static_cast<float>(ceil(pose[1]/5.0f)); // para corresponder ao Y do plot (de baixo para cima)
    
    // condições caso a janela ativa esteja fora da matriz 40 por 40
    // se estiver fora entao fica no limite da matriz
    cima = (int)(y0-floor(RectSize/2.0f));
    if(cima < 0)
        cima = 0;

    baixo = (int)(y0+floor(RectSize/2.0f));
    if(baixo > 39)
        baixo = 39;

    esq = (int)(x0-floor(RectSize/2.0f));
    if(esq < 0)
        esq = 0;
        
    dir = (int)(x0+floor(RectSize/2.0f));
    if(dir > 39)
        dir = 39;

    // Posicao do robo real (cm)
    x0 = pose[0];
    y0 = pose[1];

    // Inicialização de variaveis
    float fr[2] = {0, 0};
    float fa[2] = {0, 0};
    //float FR_magn = 0;
    //float FR_angle = 0;
    //float FA_angle = 0;
    
    float xt, yt, dist;
    
    // confirmar (x_max - x_min)
   /*for (int i = 0; i <= (baixo-cima); i++){
        for (int j = 0; j <= (dir-esq); j++){
          Janela[i][j] = Mapa_40[cima+i][esq+j];
        }
    }
    */
    for (int i = cima; i <= baixo; i++){
        for (int j = esq; j <= dir; j++){
            //if(Mapa_40[i][j]==1){
                // Posicao do pixel real (cm)
                //printf("%f\n\r", Mapa_40[i][j]);
                xt = (5.0f*(static_cast<float>(j)))-2.5f;
                yt = (5.0f*(static_cast<float>(i)))-2.5f;

                // Distância do Robo ao Pixel
                dist = sqrt(pow(yt-y0,2) + pow(xt-x0,2));
                
                // só as celulas acima de 0.6 que exercem uma forca repulsiva
                if (Mapa_40[i][j] > 0.6f){
                    fr[0] = fr[0] + Mapa_40[i][j]*FCRepul*(xt-x0)/pow(dist,3);
                    fr[1] = fr[1] + Mapa_40[i][j]*FCRepul*(yt-y0)/pow(dist,3);
                }               
            //}            
        }
    }
    
    //printf("Cima: %d, Baixo: %d, Esq= %d, Dir= %d\n\r", cima, baixo, esq, dir);
    //printf("Mapa40[28][0]= %f, Mapa_40[28][0]==1: %d\n\r", Mapa_40[28][0], Mapa_40[28][0]==1);
    
    //FA_angle = atan2((poseFinal[1]-y0), (poseFinal[0]-x0));
    
    dist = sqrt(pow(poseFinal[1]-y0,2) + pow(poseFinal[0]-x0,2));
    
    fa[0] = FCAtracao * ((poseFinal[0]-x0)/dist);
    fa[1] = FCAtracao * ((poseFinal[1]-y0)/dist);
    
    ForcaResult[0] = fa[0];
    ForcaResult[1] = fa[1];
    ForcaResult[2] = fr[0];
    ForcaResult[3] = fr[1];
    
}