/*****************************************************************************
    ml5238_reg.h

    Copyright (C) 2019 SQC Systems s.r.l.
    All rights reserved.

    SQC Systems shall not be liable for any direct, indirect, 
    consequential or incidental damages arising from using or modifying this 
    program.

    History
    2019.03.19  ver.3.00
    2012.11.20  ver.2.00
    2012.09.13  ver.1.00
******************************************************************************/
#ifndef _ML5238_REG_H_
#define _ML5238_REG_H_

#define ML5238_NOOP         (0x00u)
#define ML5238_VMON         (0x01u)
#define ML5238_IMON         (0x02u)
#define ML5238_FET          (0x03u)
#define ML5238_PSENSE       (0x04u)
#define ML5238_RSENSE       (0x05u)
#define ML5238_POWER        (0x06u)
#define ML5238_STATUS       (0x07u)
#define ML5238_CBALH        (0x08u)
#define ML5238_CBALL        (0x09u)
#define ML5238_SETSC        (0x0Au)

/**********************************
           NOOP(0x00)
**********************************/
#define NOOP_NO0    (0x01u)
#define NOOP_NO1    (0x02u)
#define NOOP_NO2    (0x04u)
#define NOOP_NO3    (0x08u)
#define NOOP_NO4    (0x10u)
#define NOOP_NO5    (0x20u)
#define NOOP_NO6    (0x40u)
#define NOOP_NO7    (0x80u)

/**********************************
           VMON(0x01)
**********************************/
#define VMON_CN0    (0x01u)
#define VMON_CN1    (0x02u)
#define VMON_CN2    (0x04u)
#define VMON_CN3    (0x08u)
#define VMON_OUT    (0x10u)

/**********************************
           IMON(0x02)
**********************************/
#define IMON_GIM    (0x01u)
#define IMON_ZERO   (0x02u)
#define IMON_GCAL0  (0x04u)
#define IMON_GCAL1  (0x08u)
#define IMON_OUT    (0x10u)


/**********************************
           FET(0x03)
**********************************/
#define FET_DF          (0x01u)
#define FET_CF          (0x02u)
#define FET_DRV         (0x10u)
#define RESET_ALL_FET   (0x00u)



/**********************************
           PSENSE(0x04)
**********************************/
#define PSENSE_PSL  (0x01u)
#define PSENSE_RPSL (0x02u)
#define PSENSE_IPSL (0x04u)
#define PSENSE_EPSL (0x08u)
#define PSENSE_PSH  (0x10u)
#define PSENSE_RPSH (0x20u)
#define PSENSE_IPSH (0x40u)
#define PSENSE_EPSH (0x80u)

/**********************************
           RSENSE(0x05)
**********************************/
#define RSENSE_RS   (0x01u)
#define RSENSE_RRS  (0x02u)
#define RSENSE_IRS  (0x04u)
#define RSENSE_ERS  (0x08u)
#define RSENSE_SC   (0x10u)
#define RSENSE_RSC  (0x20u)
#define RSENSE_ISC  (0x40u)
#define RSENSE_ESC  (0x80u)

/**********************************
           POWER(0x06)
**********************************/
#define POWER_PSV   (0x01u)
#define POWER_PDWN  (0x10u)
#define POWER_PUPIN (0x80u)

/**********************************
           STATUS(0x07)
**********************************/
#define STATUS_DF   (0x01u)
#define STATUS_CF   (0x02u)
#define STATUS_PSV  (0x04u)
#define STATUS_INT  (0x08u)
#define STATUS_RPSL (0x10u)
#define STATUS_RPSH (0x20u)
#define STATUS_RRS  (0x40u)
#define STATUS_RSC  (0x80u)

/**********************************
           CBALH(0x08)
**********************************/
#define CBALH_SW9   (0x01u)
#define CBALH_SW10  (0x02u)
#define CBALH_SW11  (0x04u)
#define CBALH_SW12  (0x08u)
#define CBALH_SW13  (0x10u)
#define CBALH_SW14  (0x20u)
#define CBALH_SW15  (0x40u)
#define CBALH_SW16  (0x80u)

/**********************************
           CBALL(0x09)
**********************************/
#define CBALL_SW1   (0x01u)
#define CBALL_SW2   (0x02u)
#define CBALL_SW3   (0x04u)
#define CBALL_SW4   (0x08u)
#define CBALL_SW5   (0x10u)
#define CBALL_SW6   (0x20u)
#define CBALL_SW7   (0x40u)
#define CBALL_SW8   (0x80u)

/**********************************
           SETSC(0x0A)
**********************************/
//0x00=33.3A 0x01=66.6A 0x10=100A 0x11=133.3A
#define SETSC_SC0   (0x00u)
#define SETSC_SC1   (0x01u)
#define SETSC_SC2   (0x10u)
#define SETSC_SC3   (0x11u)


#endif /*_ML5238_REG_H_*/
