/*****************************************************************************
    measure.h

    Copyright (C) 2012 LAPIS Semiconductor Co., Ltd.
    All rights reserved.

    LAPIS Semiconductor shall not be liable for any direct, indirect, 
    consequential or incidental damages arising from using or modifying this 
    program.

    History
    2012.11.20  ver.2.00
    2012.09.13  ver.1.00
******************************************************************************/
#ifndef _MEASURE_H_
#define _MEASURE_H_

/*############################################################################*/
/*#                                Struct                                    #*/
/*############################################################################*/
typedef struct{
    unsigned short Visense10;
    unsigned short Visense50;
    unsigned short Vim010;
    unsigned short Vim050;
/*
    unsigned short Vim110;
    unsigned short Vim150;
    unsigned short VR10;
    unsigned short VR50;
*/
    unsigned short Rsense;
    unsigned short Count_DC;

    unsigned char Count_ODC;
    unsigned char Count_OD2;
    unsigned char curState;
    unsigned char DetectForbitFlag;         //bit0:charge over current detection, bit1:discharge over current1 detection, bit2:discharge over current2 detection
    
}CurDetSt;

typedef struct{
    unsigned long Vsum;
    unsigned short OvChDelaytime;
    unsigned short OvChstate;
    unsigned short OvDisDelaytime;
    unsigned short OvDisstate;
}CellDetSt;

typedef struct {
    unsigned short Vt_pcb;
    unsigned short UChDelayCount;
    unsigned short UDisDelayCount;
    unsigned short OChDelayCount;
    unsigned short ODisDelayCount;
    unsigned char  Tadr;
    unsigned char  DetectForbitFlag;    //bit0:under tempe charge forbit, bit1:under tempe discharge forbit, bit2:over tempe charge forbit, bit3:over tempe discharge forbit
}TempeDetSt;

typedef struct{
    unsigned char UChState;
    unsigned char UDisState;
    unsigned char OChState;
    unsigned char ODisState;
//  unsigned short delayCount;
    TempeDetSt* res;
    unsigned char TempFlag;
}TempeSt;


/*############################################################################*/
/*#                                Variable                                  #*/
/*############################################################################*/

/*############################################################################*/
/*#                                define                                    #*/
/*############################################################################*/

/*############################################################################*/
/*#                                Return                                    #*/
/*############################################################################*/
#define MEAS_R_OK           (0)
#define MEAS_R_ERR_NULL     (-1)

#define CUR_NOR             (0x00u)
#define CUR_CHRG            (0x01u)
#define CUR_DISCHRG         (0x02u)
#define CUR_OVCHRG          (0x04u)
#define CUR_OVDISCHRG1      (0x08u)
#define CUR_OVDISCHRG2      (0x10u)

#define CELL_VOL_NOR        (0x00u)
#define CELL_VOL_OVD        (0x02u)
#define CELL_VOL_OVC        (0x01u)
#define CELL_VOL_OVCD       (0x04u)
#define CELL_VOL_PD         (0x05u)

#define CFET_OFF_DFET_OFF               (0x00u)
#define CFET_ON_DFET_OFF                (0x02u)
#define CFET_OFF_DFET_ON                (0x01u)
#define CFET_ON_DFET_ON                 (0x03u)

#define EEP_TEMPE_TABLE_ADR     (0x200u)
#define VMON_OUT_EN     (0x10u)

#define CURRENT_AD_FULL     (0xFF00u)
#define CURRENT_AD_NULL     (0x0100u)

#define CURRENT50_AD_FULL       (0xC000u)
#define CURRENT10_AD_FULL       (CURRENT_AD_FULL)

#define CUR_OVCH_DETEC_FORBIT       (0x01u)
#define CUR_OVDISCH1_DETEC_FORBIT   (0x02u)
#define CUR_OVDISCH2_DETEC_FORBIT   (0x04u)

#define TEMPE_UDCH_DETEC_FORBIT     (0x01u)
#define TEMPE_UDDISCH_DETEC_FORBIT  (0x02u)
#define TEMPE_OVCH_DETEC_FORBIT     (0x04u)
#define TEMPE_OVDISCH_DETEC_FORBIT  (0x08u)

#define IMON_SET_NUM        (2u)

extern const unsigned char Imon_set_table[IMON_SET_NUM];

/*############################################################################*/
/*#                                Prototype                                  #*/
/*############################################################################*/
void currentInit(CurDetSt* res);

void currentGetParam(CurDetSt* res, unsigned short* param10,unsigned short* param50, 
    unsigned short Im, unsigned char discharge_en,
    unsigned long* param10tmp, unsigned long* param50tmp);

void meas_current(CurDetSt* res);
void UpdateCurrentParamCC(CurDetSt* res,
    unsigned short* param10, unsigned short* param50,
    unsigned long param10tmp, unsigned long param50tmp);

void UpdateCurrentParamDC(CurDetSt* res,
    unsigned short* param10, unsigned short* param50,
    unsigned long param10tmp, unsigned long param50tmp);

void judgeCurrent(CurDetSt* res);
int meas_one_cell_volt(unsigned char cell_num, unsigned short* Vcell);
void meas_all_cell_volt(unsigned char con_cell_num, unsigned short* Vcell);
unsigned char JudgeCellAll(unsigned char cellNum , unsigned short* Vcell, CellDetSt* res);

void Temperature_init(TempeDetSt* res);
void getTemperature(unsigned char thNo, TempeDetSt* res);
void JudgeOneTemperature(unsigned char thNum, TempeSt* res);
unsigned short JudgeTemperature(TempeSt* res);
void fet_control(unsigned char* fetState ,unsigned short workState);

void Gas_storeVisense(CurDetSt* res);
void Gas_aveVisense(unsigned short* cvisens, unsigned short* dvisens);
void Gas_aveVisenseClear(void);


#endif /*_MEASURE_H_*/
