/*****************************************************************************
    main_def.h

    Copyright (C) 2013 LAPIS Semiconductor Co., Ltd.
    All rights reserved.

    LAPIS Semiconductor shall not be liable for any direct, indirect, 
    consequential or incidental damages arising from using or modifying this 
    program.

    History
    2013.02.20  ver.3.00
    2012.11.20  ver.2.00
    2012.09.13  ver.1.00
******************************************************************************/
#ifndef _MAIN_DEF_H_
#define _MAIN_DEF_H_

#define CELL_NUM_MAX                    (16u)
#define THERMISTOR_NUM_MAX              (8u)
#define T_END                           (85u+40u+1u)


#define SET_FLAG        (0x01u)
#define CLR_FLAG        (0x00u)

#define ST_NORMAL                       (0x0000u)
#define ST_OVRCHRG_VOL                  (0x0001u)
#define ST_OVRDISCHRG_VOL               (0x0002u)
#define ST_OVRCHRG_DISCHRG_VOL          (0x0004u)
#define ST_SHORT_CUR                    (0x0008u)

#define ST_CHRG_CUR                     (0x0010u)
#define ST_DISCHRG_CUR                  (0x0020u)
#define ST_OVRCHRG_CUR                  (0x0040u)
#define ST_OVRDISCHRG_CUR               (0x0080u)

#define ST_TOTAL_CHRG                   (0x0100u)
#define ST_CELLDIFF_CHRG                (0x0200u)
#define ST_PSAVE                        (0x0400u)
#define ST_PDOWN                        (0x0800u)

#define ST_UDR_TEMPE_CHRG               (0x1000u)
#define ST_UDR_TEMPE_DISCHRG            (0x2000u)
#define ST_OVR_TEMPE_CHRG               (0x4000u)
#define ST_OVR_TEMPE_DISCHRG            (0x8000u)
#define ST_TEMPE_DETECT                 (ST_OVR_TEMPE_DISCHRG|ST_UDR_TEMPE_DISCHRG)

#define UART_SEND_BUF_SZ                (40u)

#define STX (0x02u)

#define MAIN_R_OK               (0)
#define MAIN_R_ERR_PARAM        (-1)

#define MAIN_EEPROM_ADR         (0x0200u)   //Top Addr
#define MAIN_EEPROM_SIZE        (0x0060u)   //size of one data
#define MAIN_EEPROM_TIMES_ADR   (0x002Cu)   //Times Addr
#define MAIN_EEPROM_ENERGY_ADR  (0x0058u)   //Enegy Addr
#define MAIN_EEPROM_PAGE_SIZE   (10u)

#define GAIN10_SUB          (1u)            //(Vim1-Vim0)/VR-0.1
#define GAIN50_SUB          (5u)            //(Vim1-Vim0)/VR-0.5
#define GAIN10F             (100u-GAIN10_SUB)           //x10(Fixed)-0.1
#define GAIN50F             (500u-GAIN50_SUB)           //x50(Fixed)-0.5

#define ST_EEP_ABNRDATA     (2u)
#define ST_EEP_ALL_ERASE    (1u)
#define ST_EEP_OK           (0u)

#define EEP_INS_ABNRDATA        ((unsigned char*)"x")
#define EEP_INS_ALL_ERASE       ((unsigned char*)"y")
#define EEP_INS_OK              ((unsigned char*)"z")                           //CopyParamEEPROM()= EEP_R_NODATA, EEP_R_DATADIFF, EEP_ALL_ERASE

//using drv_ctrl_flag
#define DRVST_ON_BIT    (0x80u)
#define DRVST_OFF_BIT   (0x40u)

#define VREF_VAL            (3300u)

#endif /*_MAIN_DEF_H_*/