/*****************************************************************************
    bms.h

    Copyright (C) 2019 SQC Systems s.r.l.
    All rights reserved.

    SQC Systems shall not be liable for any direct, indirect, 
    consequential or incidental damages arising from using or modifying this 
    program.

    History
    2019.03.19  ver.1.00

******************************************************************************/
#ifndef _BMS_H_
#define _BMS_H_


/**********************************
           STATE OF BMS
**********************************/
// Define State of BMS
#define START_MODE 1
#define RUN_MODE 2
#define STANDBY_MODE 3
#define ERROR_MODE 4
#define CHARGING_MODE 5
#define RESTORE_MODE 6
#define LOW_BATTERY_MODE 7
#define POWER_DOWN_MODE 8
#define SHORT_CIRCUIT_MODE 9
#define HIGH_TEMPERATURE_CUTOFF 10
#define LOW_TEMPERATURE_CUTOFF 11

/**********************************
           EVENTS
**********************************/

// Define Events
#define EVENT_POWER_ON 0
#define EVENT_SHORT_CIRCUIT 1
#define EVENT_OVER_TEMP 2
#define EVENT_START_BMS 3
#define EVENT_LOAD_DISCONNECTED 4
#define EVENT_LOAD_RECONNECTED 5
#define EVENT_CHARGER_DISCONNECTED 6
#define EVENT_CHARGER_RECONNECTED 7
#define EVENT_BATTERY_TOO_LOW 8
#define EVENT_BATTERY_DOWN 9
#define EVENT_BATTERY_IS_FULL 10
#define EVENT_BATTERY_IS_OK 11
#define EVENT_GOTO_RUN_FROM_RESTORE 12

/**********************************
           TALK and DONE
**********************************/
#define TALK (SS_PIN = 0);              // Chip Select
#define DONE (SS_PIN = 1);              // Chip Deselect

#define SET_CAN_IN_HIGH_SPEED_MODE (RS = 0);   // Set Can Bus in high speed mode
#define SET_CAN_BUS_IN_LISTEN_MODE (RS = 1);   // Set Can Bus in Listen Only Mode

char VMON_DATA_WRITE[] = {0x00, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A , 0x1B, 0x1C, 0x1D, 0x1E, 0x1F};
int STATE_OF_BMS;
int STATE_OF_BMS_PREC;
double VIM0;
double VIM1;
double VR; 
double Gim;
double Vimz;
double Vimon;
double Isense;
double V_ref = 3.3f;
double Rsense = 0.003f;
bool schort_circuit_detection = false;
double instant_current_detected;

float LOWVOLTAGEWARNING = 35.0;         // Define low voltage warning 35
float LOWVOLTAGECUTOFF = 34.0;          // Define low voltage cut off
float HIVOLTAGESHUNT = 3.9;             // Define high voltege limit for balancing
float VOLTAGEALLOWANCE = 0.009;         // Define the accuracy the balancing algorithm can balance it to.
float HIGHVOLTAGECUTOFF = 39.00;         // Define high voltage cut off
float LOWVOLTAGEPOWERDOWN = 31.0;       // Define low voltage to put BMS in POWER_DOWN_MODE 

int TOTALCELLS = 10;                    // Number Of cells


float voltageHighest;
float voltageLowest;
int highestCellNumber;
int lowestCellNumber;


float cellVoltage[17];
float difference[17];

float voltageTotal;
float voltageAverage;
float temp_read = 0; 
float temp_min = -5;
float temp_warning = 40;
float temp_cutoff = 60;
float thr_val=0, thr_res=0, temperature=0, temperature_of_battery=0;
unsigned char read_buf,read_buf2,read_fet, read_power, rdata;
double gain_correction = 0;

//**********************************************************************************************
// Status flags READ ONLY
bool DF_STATUS = false;   // Mosfet OUT
bool CF_STATUS = false;   // Mosfet CHARGER
bool PSW_STATUS = false;  // Power safe mode
bool INT_STATUS = false;  // INT bit indicates the /INTO pin output status.
bool RPSL_STATUS = false; // RPSL bit indicates interrupt status of charger disconnecting interrupt if charge over-current detected.
bool RPSH_STATUS = false; // RPSH bit indicates interrupt status of charger disconnecting interrupt if the status is power down.
bool RRS_STATUS = false;  // RRS bit indicates interrupt status of load disconnecting interrupt
bool RSC_STATUS = false;  // RSC bit indicates interrupt status of short current detecting interrupt.
//***********************************************************************************************


// status flags of power status
bool PSV_STATUS = false; 
bool PDWN_STATUS = false; 
bool PUPIN_STATUS = false; 



// Setup ML5238
void START_UP_ML5238();
bool SET_ENABLE = true;
bool SET_DISABLE = false;
bool SET_RUN = true;
bool SET_STOP = false;


void handle_interrupt();
void read_instant_current();
void read_temperature_of_battery();
void events_of_bms();
void actions();
float vTotal();
int highestCell();
int lowestCell();
float average_voltage();
void powerdown(); 



typedef struct _Register_Map_structure {
    float Cell_1_voltage;
    float Cell_2_voltage;
    float Cell_3_voltage;
    float Cell_4_voltage;
    float Cell_5_voltage;
    float Cell_6_voltage;
    float Cell_7_voltage;
    float Cell_8_voltage;
    float Cell_9_voltage;
    float Cell_10_voltage;
    float Cell_11_voltage;
    float Cell_12_voltage;
    float Cell_13_voltage;
    float Cell_14_voltage;
    float Cell_15_voltage;
    float Cell_16_voltage;
    char Bms_uptime[32];
    uint32_t Estimated_time_left;
    float Battery_voltage;
    float Battery_current;
    float Min_cell_voltage;
    float Max_cell_voltage;
    float External_temp_sensor_1;
    float External_temp_sensor_2;
    uint16_t Distance_left;
    uint32_t State_of_charge;
    float On_board_temperature_sensor;
    uint16_t Battery_status;
    float Voltageaverage;
    float InstantPower;
    float Speed;
} Register_Map_structure;
Register_Map_structure Register_Map;



#endif /*_BMS_H_*/
