/*****************************************************************************
    param.h

    Copyright (C) 2012 LAPIS Semiconductor Co., Ltd.
    All rights reserved.

    LAPIS Semiconductor shall not be liable for any direct, indirect, 
    consequential or incidental damages arising from using or modifying this 
    program.

    History
    2012.11.20  ver.2.00
    2012.09.13  ver.1.00
******************************************************************************/
#ifndef _PARAM_H_
#define _PARAM_H_

#include "main_ext.h"

#define CELL_NUM_CON        16u
#define THER_NUM_CON        4u
#if (TESTMODE==85)
#define RSENSE_VAL          50u     //0.5[mOhm]
#elif (TESTMODE==86)
#define RSENSE_VAL          1000u       //10[mOhm]
#else
#define RSENSE_VAL          300u        //3[mOhm]
#endif
#define AH_VAL              215u        //2.15[Ah]

const static unsigned char CellNum=CELL_NUM_CON;

//Over Voltage, Over Voltage Release, Under Voltage, Under Voltage Release

const static unsigned short p_Vov=(unsigned short)((double)16*4095*(4200/2)/VREF_VAL);
const static unsigned short p_Vovr=(unsigned short)((double)16*4095*(4000/2)/VREF_VAL);
const static unsigned short p_Vuv=(unsigned short)((double)16*4095*(2800/2)/VREF_VAL);
const static unsigned short p_Vuvr=(unsigned short)((double)16*4095*(3000/2)/VREF_VAL);

const static unsigned short p_Vbsv=(unsigned short)((double)16*4095*(3600/2)/VREF_VAL);
const static unsigned short p_gvbs=(unsigned short)((double)16*4095*(100/2)/VREF_VAL);
const static unsigned short p_gvbe=(unsigned short)((double)16*4095*(70/2)/VREF_VAL);

const static unsigned long p_Vdown=(unsigned long)((double)CELL_NUM_CON*16*4095*(2750/2)/VREF_VAL);
const static unsigned short p_Vec =(unsigned short)((double)16*4095*(1400/2)/VREF_VAL);


const static unsigned short p_D_ov = 50u;                   //500ms
const static unsigned short p_D_uv = 60u;                   //600ms
#define D_CBAL_VAL      (1u)

const static unsigned short p_Rsense = RSENSE_VAL;

const static unsigned short p_Vcen = 2u;                        //200[mA]
const static unsigned short p_Vden = 2u;                        //200[mA]
const static unsigned short p_D_Vcen = 20u;                 //200[ms]
const static unsigned short p_D_Vden = 20u;                 //200[ms]

const static unsigned short p_D_Psave = 60u;                //1[min]

const static unsigned short p_Psave_time = 1000u;           //10[s]

const static unsigned short p_Viod_stg1 =200u;              //20[A]
const static unsigned short p_Viod_stg2 =500u;              //50[A]
const static unsigned short p_Vioc =40u;                        //4[A]

const static unsigned char p_D_iod_stg1 =4u;                    //40[ms]
const static unsigned char p_D_iod_stg2 =2u;                    //20[ms]

const static unsigned char p_D_iovc = 40u;                  //400[ms]

const static unsigned char p_TempeNum= THER_NUM_CON;
const static unsigned long p_Tempe25=10000u;
const static unsigned long p_TempeB=3435u;
const static unsigned long p_DivR=10000u;
const static unsigned short p_TempeTime =1000u;             //10[s]

const static char p_ut_c[THERMISTOR_NUM_MAX] = {  -5,  -5,  -5,  -5,  -5,  -5,  -5,  -5};
const static char p_utr_c[THERMISTOR_NUM_MAX]= {   5,   5,   5,   5,   5,   5,   5,   5};
const static char p_ut_d[THERMISTOR_NUM_MAX] = { -20, -20, -20, -20, -20, -20, -20, -20};
const static char p_utr_d[THERMISTOR_NUM_MAX]= { -10, -10, -10, -10, -10, -10, -10, -10};
const static char p_ot_c[THERMISTOR_NUM_MAX] = {  60,  60,  60,  60,  60,  60,  60,  60};
const static char p_otr_c[THERMISTOR_NUM_MAX]= {  50,  50,  50,  50,  50,  50,  50,  50};
const static char p_ot_d[THERMISTOR_NUM_MAX] = {  80,  80,  80,  80,  80,  80,  80,  80};
const static char p_otr_d[THERMISTOR_NUM_MAX]= {  70,  70,  70,  70,  70,  70,  70,  70};

const static unsigned short p_D_Temp=3u;

const static unsigned short p_differential_voltage=0u;

const static unsigned short p_differential_voltage_rel=(unsigned short)((double)16*4095*(50/2)/VREF_VAL);

const static unsigned long p_TotalCellVol_ChargerEna=0u;

const static unsigned long p_TotalCellVol_ChargerEna_rel=(unsigned long)((double)16*4095*(60000/2)/VREF_VAL);

const static unsigned short p_Ah_Val=AH_VAL;

const static unsigned short p_Veint=(unsigned short)((double)16*4095*(3600/2)/VREF_VAL);

const static unsigned char p_Product_Id[PRODUCT_ID_NUM] = {'M','3','8'};            //Product ID

const static unsigned char p_ShortC= 2u;                                            //0.3[V]

const static unsigned char p_eepUpTime= 1u;                                         //1[min]-10[min]

//
//#define ENERGY_X      (0x00015D17)                //(  X x 1000 x 3600 / ((3300x1000)/(4096/*xRSENSExGim*/))  ) x (1000 / 50)
#define SELFDCHG_VALUE      (625u)
//#define Energy_All        ((double)AH_VAL*ENERGY_X*RSENSE_VAL/100/100u)
#define Energy_All      ((double)AH_VAL*36*4095*20*RSENSE_VAL/3300/100u)

const static unsigned long p_Energy_100 = (unsigned long)(Energy_All);
const static unsigned long p_Energy_80 = (unsigned long)(Energy_All * 0.80);
const static unsigned long p_Energy_60 = (unsigned long)(Energy_All * 0.60);
const static unsigned long p_Energy_40 = (unsigned long)(Energy_All * 0.40);
const static unsigned long p_Energy_20 = (unsigned long)(Energy_All * 0.20);
const static unsigned long p_Energy_10min = Energy_All / (24u * 6u) / SELFDCHG_VALUE;       //(X * 1000 * 3600 / 32.227) * (1000 / 10)


const static unsigned char p_waitTimes = 1u;
const static unsigned char p_ImonInit_waitTimes = 1u;
const static unsigned char p_Imon_waitTimes = 1u;
const static unsigned char p_fDrv_waitTimes = 3u;
const static unsigned char p_pd_waitTimes = 3u;
const static unsigned char psl_waitTimes = 10u;
const static unsigned char p_psl_waitTimes = 10u;

#endif //_PARAM_H_
