/*****************************************************************************
    main_struct.h

    Copyright (C) 2012 LAPIS Semiconductor Co., Ltd.
    All rights reserved.

    LAPIS Semiconductor shall not be liable for any direct, indirect, 
    consequential or incidental damages arising from using or modifying this 
    program.

    History
    2012.11.20  ver.2.00
    2012.09.13  ver.1.00
******************************************************************************/
#ifndef _MAIN_STRUCT_H_
#define _MAIN_STRUCT_H_

typedef struct{
    unsigned char cellNum;          //Cell Instruction number(0 cell to 15cell)
    unsigned char tempeNum;         //Thermister Instruction number(0 cell to 15cell)
    unsigned char CellNumCon;
    unsigned char ThermisNumCon;

    unsigned short TempCount;       //the count number of 10ms(10000ms-60000ms)
    unsigned char VcellAllMeasFlag;     //Task_Vflag
    unsigned char TempeOneMeasFlag;     //Finished the basic cycle

    unsigned short BalanceNow;
    unsigned short BalanceCount;        //0.1s to 1s

    unsigned char BalanceStartFlag;
    unsigned char PsaveTransFlag;
    unsigned char PsaveReturnFlag;
    unsigned char PsaveEepromFlag;

    unsigned long PsaveDelayCount;          //Use at interval time and delay time.

    unsigned long eepUpCount;

    unsigned short Count_LED;
    unsigned short BalanceFlag;
}MainSt;

typedef struct{
    unsigned long Charge_Num;
    unsigned long Discharge_Num;
    unsigned long OvCh_Num;
    unsigned long OvDis_Num;
    unsigned long OvCharge_Num;
    unsigned long OvDischarge_Num;
    unsigned long Short_Num;
    unsigned long UdTempeCh_Num;
    unsigned long UdTempeDis_Num;
    unsigned long OvTempeCh_Num;
    unsigned long OvTempeDis_Num;
}DetectTimes;

typedef struct{
    unsigned long Energy100;
    unsigned long Energy80;
    unsigned long Energy60;
    unsigned long Energy40;
    unsigned long Energy20;
    unsigned long Energy10min;
}EnergyLevel;

#endif /*_MAIN_STRUCT_H_*/
