/*****************************************************************************
    main_ext.h

    Copyright (C) 2012 LAPIS Semiconductor Co., Ltd.
    All rights reserved.

    LAPIS Semiconductor shall not be liable for any direct, indirect, 
    consequential or incidental damages arising from using or modifying this 
    program.

    History
    2012.11.20  ver.2.00
    2012.09.13  ver.1.00
******************************************************************************/
#ifndef _MAIN_EXT_H_
#define _MAIN_EXT_H_

#include "main_struct.h"
#include "main_def.h"
#include "measure.h"

#define PRODUCT_ID_NUM      (3)

extern MainSt process;
extern CurDetSt curResult;
extern CellDetSt cellResult;
extern TempeSt tempState;
extern TempeDetSt tempeResult[THERMISTOR_NUM_MAX];
extern DetectTimes times;
extern EnergyLevel level;

extern unsigned short Work_State;
extern unsigned char uart_send_buf[UART_SEND_BUF_SZ];

extern unsigned short Vinl10;
extern unsigned short Vinl50;
extern unsigned short Vinh10;
extern unsigned short Vinh50;
extern unsigned short Vioc10;
extern unsigned short Vioc50;
extern unsigned short Viod_stg110;
extern unsigned short Viod_stg150;
extern unsigned short Viod_stg210;
extern unsigned short Viod_stg250;
extern unsigned short Vut_c[THERMISTOR_NUM_MAX];
extern unsigned short Vutr_c[THERMISTOR_NUM_MAX];
extern unsigned short Vut_d[THERMISTOR_NUM_MAX];
extern unsigned short Vutr_d[THERMISTOR_NUM_MAX];
extern unsigned short Vot_c[THERMISTOR_NUM_MAX];
extern unsigned short Votr_c[THERMISTOR_NUM_MAX];
extern unsigned short Vot_d[THERMISTOR_NUM_MAX];
extern unsigned short Votr_d[THERMISTOR_NUM_MAX];


extern unsigned short Vov;
extern unsigned short Vovr;
extern unsigned short Vuv;
extern unsigned short Vuvr;

extern unsigned short Vbsv;
extern unsigned short gvbs;
extern unsigned short gvbe;

extern unsigned long Vdown;
extern unsigned short Vec;


extern unsigned short D_ov;
extern unsigned short D_uv;


//extern unsigned short Rsense;

extern unsigned short Vcen;
extern unsigned short Vden;
extern unsigned short D_Vcen;
extern unsigned short D_Vden;

extern unsigned short D_Psave;

extern unsigned short Psave_time;

extern unsigned short Viod_stg1;
extern unsigned short Viod_stg2;
extern unsigned short Vioc;

extern unsigned char D_iod_stg1;
extern unsigned char D_iod_stg2;

extern unsigned char D_iovc;

//extern unsigned char TempeNum;
extern unsigned long Tempe25;
extern unsigned long TempeB;
extern unsigned long DivR;
extern unsigned short TempeTime;


extern unsigned short D_Temp;
extern unsigned short differential_voltage;
extern unsigned long TotalCellVol_ChargerEna;
extern unsigned short Ah_Val;
extern unsigned short Veint;
extern unsigned char Product_Id[PRODUCT_ID_NUM];
extern unsigned char ShortC;
extern unsigned char eepUpTime;         //1[min] to 10[min]

extern unsigned short differential_voltage_rel;
extern unsigned long TotalCellVol_ChargerEna_rel;

extern char ut_c[THERMISTOR_NUM_MAX];
extern char utr_c[THERMISTOR_NUM_MAX];
extern char ut_d[THERMISTOR_NUM_MAX];
extern char utr_d[THERMISTOR_NUM_MAX];
extern char ot_c[THERMISTOR_NUM_MAX];
extern char otr_c[THERMISTOR_NUM_MAX];
extern char ot_d[THERMISTOR_NUM_MAX];
extern char otr_d[THERMISTOR_NUM_MAX];

extern unsigned char ut_c_th_target;
extern unsigned char ut_d_th_target;
extern unsigned char ot_c_th_target;
extern unsigned char ot_d_th_target;

extern unsigned long Energy;

extern unsigned short uart_rw_size;
extern unsigned short uart_r_size;
extern unsigned char eep_count_Flag;

extern unsigned char threshold_mode_status;
extern volatile unsigned char Thres_req0_flg;
extern volatile unsigned char Thres_req1_flg;
extern volatile unsigned char Thres_req2_flg;
extern volatile unsigned char senddata_cont_flg;
extern volatile unsigned char WDT_flag;
extern volatile unsigned char eeprom_read_state;        //0:there ara parameters to eeprom, else:there are no parameters.

extern unsigned char shortDet_flag; //Add 14.07.10
extern volatile unsigned char External0_en_flag;

extern void clk_wait1ms(void);
extern void main_clrWDT( void );
extern void uart_send_param(unsigned char* uart_buf);
extern int _eeprom_write_data(unsigned int address, unsigned char* buff, unsigned int size);
extern int _eeprom_read_data(unsigned int address, unsigned char* buff, unsigned int size);
extern void Uart_SendString(unsigned char* buf, unsigned short len);
void ltoa_hex(unsigned char* str_buff, unsigned char* data_buff, int byte_size);
extern void EnergyCalcCur(void);

#endif /*_MAIN_EXT_H_*/
