/*--------------------------------------------------------------------------------
Filename: TOF.h
Description: Header file for adafruit VL_6180X TOF sensor
--------------------------------------------------------------------------------*/
#ifndef TOF_H
#define TOF_H

/*--------------------------------------------------------------------------------
---------------------------------DEFINES------------------------------------------
--------------------------------------------------------------------------------*/

//Sensor addresses
#define DEFAULT_ADDR 0x52
#define ADDR1    0x29
#define ADDR4    0x2A
#define ADDR6    0x2C
#define ADDR7    0x2E

//Device model identification number
#define MODEL_ID                        0x000

//Interrupt configuration
#define INTERRUPT_CONFIG                0x014

//Interrupt clear bits
#define INTERRUPT_CLEAR                 0x015

//Fresh out of reset bit
#define FRESH_OUT_OF_RESET              0x016

//Trigger Ranging
#define SYSRANGE_START                  0x018

//Trigger Lux Reading
#define SYSALS_START                    0x038

//Lux reading gain
#define SYSALS_ANALOGUE_GAIN            0x03F

//Integration period for ALS mode, high byte
#define SYSALS_INTEGRATION_PERIOD_HI    0x040

//Integration period for ALS mode, low byte
#define SYSALS_INTEGRATION_PERIOD_LO    0x041

//Specific error codes
#define RESULT_RANGE_STATUS             0x04d

//Interrupt status
#define RESULT_INTERRUPT_STATUS_GPIO    0x04f

//Light reading value
#define RESULT_ALS_VAL                  0x050

//Ranging reading value
#define RESULT_RANGE_VAL                0x062

#define ALS_GAIN_1         0x06  // 1x gain
#define ALS_GAIN_1_25      0x05  // 1.25x gain
#define ALS_GAIN_1_67      0x04  // 1.67x gain
#define ALS_GAIN_2_5       0x03  // 2.5x gain
#define ALS_GAIN_5         0x02  // 5x gain
#define ALS_GAIN_10        0x01  // 10x gain
#define ALS_GAIN_20        0x00  // 20x gain
#define ALS_GAIN_40        0x07  // 40x gain

#define ERROR_NONE         0   // Success!
#define ERROR_SYSERR_1     1   // System error
#define ERROR_SYSERR_5     5   // Sysem error
#define ERROR_ECEFAIL      6   // Early convergence estimate fail
#define ERROR_NOCONVERGE   7   // No target detected
#define ERROR_RANGEIGNORE  8   // Ignore threshold check failed
#define ERROR_SNR          11  // Ambient conditions too high
#define ERROR_RAWUFLOW     12  // Raw range algo underflow
#define ERROR_RAWOFLOW     13  // Raw range algo overflow
#define ERROR_RANGEUFLOW   14  // Raw range algo underflow
#define ERROR_RANGEOFLOW   15  // Raw range algo overflow

/*--------------------------------------------------------------------------------
---------------------------------CLASSES------------------------------------------
--------------------------------------------------------------------------------*/

// Class for managing connection and state to a VL6180X sensor

class cAdafruit_VL6180X
{
public:
    cAdafruit_VL6180X(DigitalOut sensor1, DigitalOut sensor2, DigitalOut sensor3, DigitalOut sensor4);  //Constructor, initialises the 4 input sensors
    int Init(uint8_t address);              //Initialisation routine
    int Start_Range(uint8_t address);       //Start measurements command
    int Poll_Range(uint8_t address);        //Poll for measurement
    int Read_Range(uint8_t address);        //Read and return measurement
    int Clear_Interrupts(uint8_t address);  //Clear all interrupts
    void Setup(uint8_t address, uint8_t newaddress);//Address configuration routiune
private:
    void WriteByte(uint8_t address, wchar_t reg,char data);  //Write byte via I2C libraries
    char ReadByte(uint8_t address, wchar_t reg);             //Read byte via I2C libraries (first write to target address then read the byte)

};

/*--------------------------------------------------------------------------------
-----------------------------------Functions---------------------------------------
--------------------------------------------------------------------------------*/
uint8_t serviceTOF(cAdafruit_VL6180X VL6180X, uint8_t address); //Perform a read of the targeted TOF sensor

/*--------------------------------------------------------------------------------
--------------------------------External Variables--------------------------------
--------------------------------------------------------------------------------*/

#endif