/*--------------------------------------------------------------------------------
Filename: LED.h
Description: Header file for the Buzzer and LEDs
--------------------------------------------------------------------------------*/

#include "mbed.h"

#ifndef LED_H
#define LED_H

#define DIAG_GRN PD_14
#define DIAG_BLU PD_15
#define DIAG_RED PF_12

class cRGB_LED
{
    
public:
    cRGB_LED(DigitalOut DIAG_RED, PwmOut DIAG_BLU, PwmOut DIAG_GRN);  //Constructor, initialises the 3 outputs
    void red_led();     //Turns on Red LED
    void blue_led();    //Turns on Blue LED
    void green_led();   //Turns on Green LED
    void yellow_led();  //Turns on multiple LEDs to make yellow
    void orange_led(); //Turns on multiple LEDs to make orange
    void led_off();     //Turns all LEDs off
    void record_power(float vBatt); //Saves power value to private variable  for use inside class
    void display_power(); //Sets LED colour based on battery level
private:
    DigitalOut _DIAG_RED;
    PwmOut _DIAG_BLU;       
    PwmOut _DIAG_GRN;
    float _battery_level;
};


#endif