/*--------------------------------------------------------------------------------
Filename: LED.cpp
Description: Holds source code for configuring the RGB LED and also buzzer becuase 
             where else do I put it :P
--------------------------------------------------------------------------------*/

#include "LED.h"

/*--------------------------------------------------------------------------------
Function name: cRGB_LED
Input Parameters: N/A
Output Parameters: N/A
Description: Class constructor (Initialisation upon creating class)
----------------------------------------------------------------------------------*/
cRGB_LED::cRGB_LED(DigitalOut DIAG_RED, PwmOut DIAG_BLU, PwmOut DIAG_GRN): _DIAG_RED(DIAG_RED), _DIAG_BLU(DIAG_BLU), _DIAG_GRN(DIAG_GRN)
{
    // Set initial condition of PWM
    _DIAG_BLU.period(0.001); //1KHz
    _DIAG_BLU = 0;

    // Set initial condition of PWM
    _DIAG_GRN.period(0.001); //1KHz
    _DIAG_GRN = 0;

    // Initial condition of output enables
    _DIAG_RED = 0;
    
    //Initialise battery level
    _battery_level = 0;
    
}

/*--------------------------------------------------------------------------------
Function name: cRGB_LED
Input Parameters: N/A
Output Parameters: N/A
Description: Turns on red led
----------------------------------------------------------------------------------*/
void cRGB_LED::red_led()
{
    _DIAG_RED = 1;      //Enable red
    _DIAG_BLU = 0.0;    //Disable Blue
    _DIAG_GRN = 0.0;    //Disable Green
}

/*--------------------------------------------------------------------------------
Function name: blue_led()
Input Parameters: N/A
Output Parameters: N/A
Description: Turns on blue led
----------------------------------------------------------------------------------*/
void cRGB_LED::blue_led()
{
    _DIAG_RED = 0;      //Disable Red
    _DIAG_BLU = 1.0;    //Enable Blue
    _DIAG_GRN = 0.0;    //Enable Green
}

/*--------------------------------------------------------------------------------
Function name: green_led()
Input Parameters: N/A
Output Parameters: N/A
Description: Turns on green led
----------------------------------------------------------------------------------*/
void cRGB_LED::green_led()
{
    _DIAG_RED = 0;      //Disable Red
    _DIAG_BLU = 0.0;    //Disable Blue
    _DIAG_GRN = 1.0;    //Enable Green 
}

/*--------------------------------------------------------------------------------
Function name: yellow_led()
Input Parameters: N/A
Output Parameters: N/A
Description: Turns on yellow led
----------------------------------------------------------------------------------*/
void cRGB_LED::yellow_led()
{
    _DIAG_RED = 1;      //Enable Red
    _DIAG_BLU = 0.0;    //Disable Blue
    _DIAG_GRN = 0.35;   //Enable Green at 35% duty 
}

/*--------------------------------------------------------------------------------
Function name: ORANGE_LED ()
Input Parameters: N/A
Output Parameters: N/A
Description: Turns on orange led
----------------------------------------------------------------------------------*/
void cRGB_LED::orange_led()
{
    _DIAG_RED = 1.0f;      //Enable Red
    _DIAG_BLU = 0.0f;    //Disable Blue
    _DIAG_GRN = 0.647f;   //Enable Green at 35% duty 
}

/*--------------------------------------------------------------------------------
Function name: led_off()
Input Parameters: N/A
Output Parameters: N/A
Description: Turns the led off
----------------------------------------------------------------------------------*/
void cRGB_LED::led_off()
{
    _DIAG_RED = 0;  //Disable Red
    _DIAG_BLU = 0;  //Disable Blue
    _DIAG_GRN = 0;  //Disable Green
}


/*--------------------------------------------------------------------------------
Function name: record_power()
Input Parameters: vBatt - the battery voltage level
Output Parameters: N/A
Description: Stores an input battery level privately in the LED class
----------------------------------------------------------------------------------*/
void cRGB_LED::record_power(float vBatt)
{
    _battery_level = vBatt; //Record battery level for LED class
}

/*--------------------------------------------------------------------------------
Function name: display_power()
Input Parameters: N/A
Output Parameters: N/A
Description: Sets the LED colour based on the input voltage levels
----------------------------------------------------------------------------------*/
void cRGB_LED::display_power()
{
    if (_battery_level >= 4.0f)
    {
        green_led();  //Power above 70%      
    }
    else if (_battery_level < 4.0f){
    
        orange_led();  //Power above 40%
    }
    else if (_battery_level < 3.70f) 
    {
        red_led();  //Low power needs charging
    }
    else{
        
        //SOMETHING WENT WRONG!
    }  
}
