/*--------------------------------------------------------------------------------
Filename: power.h
Description: Header file for monitoring battery voltages
--------------------------------------------------------------------------------*/

#include "mbed.h"

#ifndef POWER_H
#define POWER_H

/*--------------------------------------------------------------------------------
---------------------------------DEFINES------------------------------------------
--------------------------------------------------------------------------------*/
#define VBATT  PB_1
#define V5     PC_2
#define V3     PF_4 

/*--------------------------------------------------------------------------------
---------------------------------CLASSES------------------------------------------
--------------------------------------------------------------------------------*/

class cPower
{
public:
    cPower(AnalogIn vbatt, AnalogIn fiveVolts, AnalogIn threeVolts);  //Constructor, initialises the 4 input sensors
    float monitor_battery();
    float monitor_5v_line();
    float monitor_3v3_line();
private:
    AnalogIn _vbatt;
    AnalogIn _5v0;
    AnalogIn _3v3;
};

/*--------------------------------------------------------------------------------
-----------------------------------Functions---------------------------------------
--------------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------------
--------------------------------External Variables--------------------------------
--------------------------------------------------------------------------------*/

#endif
