/*--------------------------------------------------------------------------------
Filename: power.cpp
Description: Power management source code
--------------------------------------------------------------------------------*/

#include "mbed.h"
#include "power.h"

/*--------------------------------------------------------------------------------
Function name: cAdafruit_VL6180X
Input Parameters: N/A
Output Parameters: N/A
Description: Class constructor (Initialisation upon creating class)
----------------------------------------------------------------------------------*/
cPower::cPower(AnalogIn vbatt, AnalogIn fiveVolts, AnalogIn threeVolts) : _vbatt(vbatt), _5v0(fiveVolts), _3v3(threeVolts)
{
    
}

/*--------------------------------------------------------------------------------
Function name: WriteByte(wchar_t reg,char data)
Input Parameters: reg - the register of the data to write, data - the data to send
Output Parameters: N/A
Description: Writes a single byte to a specified address using the I2C libraries
----------------------------------------------------------------------------------*/
float cPower::monitor_battery()
{
    float tempPower;
    tempPower = _vbatt * 2.0f * 3.3f; //Scales to account for the potential divider
    return tempPower;
}

float cPower::monitor_5v_line()
{
    float tempPower;
    tempPower = _5v0 * 3.0f * 3.3f; //Scales to account for the potential divider
    return tempPower;
}

float cPower::monitor_3v3_line()
{
    float tempPower;
    tempPower = _3v3 * 2.0f * 3.3f; //Scales to account for the potential divider
    return tempPower;
}