#include "mbed.h"
#include "C12832.h"

 
AnalogIn analog_value(A0);
AnalogIn POT1(PA_0);
AnalogIn POT2(PA_1);
DigitalOut led(LED1);
C12832 lcd(PA_7,PA_5,PA_6,PA_8,PB_6);
Serial pc(SERIAL_TX, SERIAL_RX);


int main() {
    int meas;
    float val;
    pc.printf("\nAnalogIn example\n");
    
    while(1) {
        meas = analog_value.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
        //meas = meas * 3.3; // Change the value to be in the 0 to 3300 range
        val = POT2.read();
        meas = POT1.read_u16();
       pc.printf("\n measure = %4X \n", meas);
        pc.printf("valeur = %.2f V", val);
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("valeur du pot : %.2f", val);
        lcd.locate(0,15);
        lcd.printf("valeur du pot : %4X", meas);
        
        if (meas > 2000) { // If the value is greater than 2V then switch the LED on
          led = 1;
        }
        else {
          led = 0;
        }
        wait_ms(1000); // 200 ms
    }
}
