//Projet téléchargé depuis : https://os.mbed.com/teams/SNE-S1S2-prime/code/Mon_premier_automate/
//Université Paris-Saclay - IUT de Cachan
//SNE S1 Prime   GR DP mai 2020
//***********************************************//
//#include "mbed.h"  //
#include "ihm_L476.h"
DigitalIn BPC (PA_0,PullNone) ;  // bouton centre
DigitalIn DOWN (PA_5,PullDown) ;  // bouton centre
DigitalOut LG (PE_8) ;  // led verte
DigitalOut LR (PB_2) ;  // led rouge
IHM_L476 ihm;
Serial pc(SERIAL_TX, SERIAL_RX);
Timer tt;

// prototype et variables globales et constantes
void automate(void);
//
void affich(void)
{
    int ch=tt.read_ms()/10 ; // valeur en 1/100 de seconde
    int cc=ch%100;  // centièmes
    int sst=ch/100;
    int ss=sst%60;
    int mm=sst/60;
    ihm.LCD_printf("%02d:%02d:%02d",mm,ss,cc);
}
int main()
{
    // début de l'application
    while(1) {
        wait(0.001);  //c'est la clock
        automate(); // ce qui se produit sur top de clock
    }
}
void automate(void)
{
    // définition d'un type énuméré permettant de manipuler l'état de l'automate
    // par son nom
    typedef enum {etat0=0, etat1=1, etat2=2, etat3=3, reset=4} type_etat;
    type_etat etat_actuel = etat0 ;   // déclaration état actuel init. à etat0
    static type_etat etat_futur = etat0;  // déclaration état futur
    int stst;  // start stop
    int rslp;  // start stop
    // gestion des entrees
    stst = BPC;  // c'est le bouton centre
    rslp = DOWN; //
    // gestion du diagramme de transition
    etat_actuel = etat_futur;   // mise à jour de l'état
    // calul de l'éat futur en fonction de l'état actuel et des entrées
    switch(etat_actuel) {
        case etat0 :
            if (stst) etat_futur = etat1;
            if (rslp) etat_futur = reset;
            break;
        case etat1 :
            if (!stst) etat_futur = etat2;
            break;
        case etat2 :
            if (stst) etat_futur = etat3;
            break;
        case etat3 :
            if (!stst) etat_futur = etat0;
            break;
        case reset :
            etat_futur = etat0;
            break;
    }
    // valeurs des  sorties en fonction de l'état actuel
    switch(etat_actuel) {
        case etat0 :
            ihm.BAR_set(0);
            pc.printf("Etat 0 \r\n");
            affich();
            LG=1;
            LR=1;
            break;
        case etat1 :
            ihm.BAR_set(1);
            pc.printf("Etat 1 \r\n");
            tt.start();
            affich();
            LG=0;
            LR=1;
            break;
        case etat2 :
            ihm.BAR_set(2);
            pc.printf("Etat 2 \r\n");
           affich();
            LG=1;
            LR=0;
            break;
        case etat3 :
            ihm.BAR_set(3);
            pc.printf("Etat 3 \r\n");
            tt.stop();
            affich();
            LG=1;
            LR=1;
            break;
        case reset :
            ihm.BAR_set(4);
            pc.printf("Etat 4 \r\n");
            tt.reset();
            affich();
            LG=1;
            LR=1;
            break;
    }
}