/// @file TimeUtilities.cpp contains a real time clock interface for the mbed
///
///

#include "mbed.h"


#define VERSION "1.04"

#include "RTC_IUT.h"
#include <time.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

Rtc::Rtc()
{
}

Rtc::~Rtc()
{
}

time_t Rtc::GetTimeValue()
{
    return time(NULL);
}

void Rtc::SetTimeValue(time_t t)
{
    set_time(t);
}

void Rtc::GetTimeString(char *buf)
{
    time_t seconds = time(NULL);
    strftime(buf, 32, "%d/%m/%Y %H:%M:%S", localtime(&seconds));
}

void Rtc::SetYear(unsigned short yyyy)
{
    struct tm *date;
    time_t epoch=time(NULL);
    date=localtime(&epoch);
    date->tm_year=yyyy-1900;
    epoch=mktime(date);
    //printf("epoch = %ud \n",epoch);
    set_time(epoch);
}

unsigned short Rtc::GetYear(void)
{
    struct tm *date;
    time_t epoch=time(NULL);
    date=localtime(&epoch);
    return date->tm_year+1900;
}

void Rtc::SetMon(unsigned char y)
{
    struct tm *date;
    time_t epoch=time(NULL);
    date=localtime(&epoch);
    date->tm_mon=y-1;
    epoch=mktime(date);
    //printf("epoch = %ud \n",epoch);
    set_time(epoch);
}

unsigned char Rtc::GetMon(void)
{
    struct tm *date;
    time_t epoch=time(NULL);
    date=localtime(&epoch);
    return date->tm_mon+1;
}

void Rtc::SetDay(unsigned char y)
{
    struct tm *date;
    time_t epoch=time(NULL);
    date=localtime(&epoch);
    date->tm_mday=y;
    epoch=mktime(date);
    //printf("epoch = %ud \n",epoch);
    set_time(epoch);
}

unsigned char Rtc::GetDay(void)
{
    struct tm *date;
    time_t epoch=time(NULL);
    date=localtime(&epoch);
    return date->tm_mday;
}

void Rtc::SetHour(unsigned char y)
{
    struct tm *date;
    time_t epoch=time(NULL);
    date=localtime(&epoch);
    date->tm_hour=y;
    epoch=mktime(date);
    //printf("epoch = %ud \n",epoch);
    set_time(epoch);
}

unsigned char Rtc::GetHour(void)
{
    struct tm *date;
    time_t epoch=time(NULL);
    date=localtime(&epoch);
    return date->tm_hour;
}

void Rtc::SetMin(unsigned char y)
{
    struct tm *date;
    time_t epoch=time(NULL);
    date=localtime(&epoch);
    date->tm_min=y;
    epoch=mktime(date);
    //printf("epoch = %ud \n",epoch);
    set_time(epoch);
}


unsigned char Rtc::GetMin(void)
{
    struct tm *date;
    time_t epoch=time(NULL);
    date=localtime(&epoch);
    return date->tm_min;
}

void Rtc::SetSec(unsigned char y)
{
    struct tm *date;
    time_t epoch=time(NULL);
    date=localtime(&epoch);
    date->tm_sec=y;
    epoch=mktime(date);
    //printf("epoch = %ud \n",epoch);
    set_time(epoch);
}

unsigned char Rtc::GetSec(void)
{
    struct tm *date;
    time_t epoch=time(NULL);
    date=localtime(&epoch);
    return date->tm_sec;
}

// DD/MM/YYYY HH:MM:SS
bool Rtc::SetTimeString(char * timestring)
{
    bool success = false;
    time_t seconds = time(NULL);
    struct tm *t = localtime(&seconds);
    unsigned int dd,MM,yyyy,hh,mm,ss;
    //printf("str : %s\r\n",timestring);
    success=sscanf(timestring,"%d/%d/%d %d:%d:%d",&dd,&MM,&yyyy,&hh,&mm,&ss);
    if(success) {
        //printf("dd=%d\r\n",dd);
        t->tm_mday = dd ;
        t->tm_mon = MM-1;
        t->tm_year = yyyy - 1900;
        t->tm_hour = hh;
        t->tm_min = mm;
        t->tm_sec = ss;
    }
    seconds = mktime(t);
    set_time(seconds);
    return success;
}
