//Université Paris-Saclay - IUT de Cachan
//SNE S1 Prime   GR DP mai 2020   
//***********************************************//
//#include "mbed.h"  // commenté car présent dans l'include ihm
#include "ihm_L476.h"
DigitalIn BPC (PA_0,PullNone) ;  // bouton centre
DigitalOut LG (PE_8) ;  // led verte
DigitalOut LR (PB_2) ;  // led rouge
IHM_L476 ihm;

// prototype et variables globales et constantes
void automate(void);
//
int main()
{
    ihm.LCD_printf("AUTO1");
    // début de l'application
    while(1) {
        wait(0.2);  //c'est la clock (5 Hz)
        automate(); // ce qui se produit sur top de clock
    }
}
void automate(void)
{
    // définition d'un type énuméré permettant de manipuler l'état de l'automate
    // par son nom
    typedef enum {etat0=0, etat1=1, etat2=2} type_etat;
    type_etat etat_actuel = etat0 ;   // déclaration état actuel init. à etat0
    static type_etat etat_futur = etat0;  // déclaration état futur
    int entree;
    // gestion des entrees
    entree = BPC;  // c'est le bouton centre
    // gestion du diagramme de transition
    etat_actuel = etat_futur;   // mise à jour de l'état
    // calul de l'éat futur en fonction de l'état actuel et des entrées
    switch(etat_actuel) {
        case etat0 :
            if (entree) etat_futur = etat1;
            break;
        case etat1 :
            etat_futur = etat2;
            break;
        case etat2 :
            etat_futur = etat0;
            break;
    }
    // valeurs des  sorties en fonction de l'état actuel
    switch(etat_actuel) {
        case etat0 :
            ihm.BAR_set(0);
            LG=1;
            LR=1;
            break;
        case etat1 :
            ihm.BAR_set(1);
            LG=0;
            LR=1;
            break;
        case etat2 :
            ihm.BAR_set(2);
            LG=1;
            LR=0;
            break;
    }
}